<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use Redirect;
use DB;
use App\InvoiceDetail;
use App\Mutasi;
use App\Stock;
use App\Product;
use App\User_logs;
use App\User;

class MutasiController extends Controller
{
   public function index()
   {
 
        $kemasan = DB::table('dt_invoice')
                    ->select(DB::raw('id_inv, type_brg, id_brg, inv_tgl, inv_qty, tonase_vol, qty_sale, tonase_sale, qty_out, tonase_out, qty_adj, tonase_adj'))
                    ->where('dt_invoice.type_brg', '=', 0)
                    ->where('dt_invoice.active_sts', '=', 1)
                    ->whereRaw('inv_qty - qty_sale - qty_out + qty_adj > ?', [0])
                    ->get();	                            
	                            
	    $satuan = Product::where('type_brg', '=', 1)
	                        ->get();
	   
		return view('mutasi.index', compact('kemasan', 'satuan'));
   }

   public function listData()
   {

        $mts = DB::table('dt_invoice')
                    ->select(DB::raw('id_inv, type_brg, id_brg, inv_tgl, inv_qty, tonase_vol, active_sts,
						qty_sale, tonase_sale, qty_out, tonase_out, qty_adj, tonase_adj'))
                    ->where('dt_invoice.type_brg', '=', 0)
                    ->where('dt_invoice.active_sts', '=',1)
                    ->whereRaw('inv_qty - qty_sale - qty_out + qty_adj > ?', [0])
                    ->get();	         
        
     $data = array();
     foreach($mts as $list){

        $stk = $list->inv_qty - $list->qty_sale - $list->qty_out + $list->qty_adj;
        $tns = $list->tonase_vol - $list->tonase_sale - $list->tonase_out + $list->tonase_adj;
        
        $row = array();

        $row[] = Product::Product($list->id_brg)->nama_brg;
        $row[] = tanggal_indonesia($list->inv_tgl, false);
        $row[] = format_uang($stk).'/'.$tns;
        
        if(Auth::user()->mutasi_add==1){
            $row[] = '<div class="btn-btn">
                   <a onclick="MutasiForm('.$list->id_inv.')" class="btn btn-success btn-sm"><i class="fa fa-exchange" ></i></a>
                   </div>';
        }else{
            $row[] = '<div class="btn-btn">
                   <a onclick="errMess('.$list->id_inv.')" class="btn btn-default btn-sm"><i class="fa fa-exchange" ></i></a>
                   </div>';
        }
        $data[] = $row;
     }

     $output = array("data" => $data);
     return response()->json($output);
	 
   }

   public function listdata1()
   {
       $mts = Mutasi::all();
       
       $data = array();
       
       foreach( $mts as $list ){
           
           $row = array();
           $row[] = tanggal_indonesia( $list->mts_tgl, false);
           $row[] = Product::Product($list->brg_asal)->nama_brg;
           $row[] = Product::Product($list->brg_tujuan)->nama_brg;
           $row[] = format_uang($list->mts_qty).'/'.$list->mts_tonase;
           $row[] = User::NamaUser($list->user_id)->username;
           
           $data[] = $row; 
       }

     $output = array("data" => $data);
     return response()->json($output);   
   }
   

   public function store(Request $request)
    {
	   echo json_encode(array('msg'=>'success'));
     }


    public function show($id)
    {
		
	}
    
    public function edit($id)
    {
      $dtinv = InvoiceDetail::find($id);
	  $barang = Product::find($dtinv->id_brg);
	  echo json_encode(array_merge(json_decode($barang, true),json_decode($dtinv, true)));
	 
    }

   public function update(Request $request, $id)
   {
		$dtinv = InvoiceDetail::find($id);   
		
		$oldqqq = $dtinv->qty_out;
		$oldtns = $dtinv->tonase_out;
		
		$qqq	= $request['qty'];
		$ttt	= $request['tns'];
		$asl	= $request['brg1'];
		
		$tjn	= Product::Product($asl)->child_to;		//$request['brg2'];
		
		/*simpan data mutasi*/
		$mutasi	= New Mutasi;
		$mutasi->mts_tgl	= date('Y-m-d');
		$mutasi->inv_id     = $id;
		$mutasi->brg_asal	= $asl;
		$mutasi->brg_tujuan	= $tjn;
		$mutasi->mts_qty	= $qqq;
		$mutasi->mts_tonase	= $ttt;
		$mutasi->user_id	= Auth::user()->id;
		$mutasi->save();
	

		/* update detail invoice */
		$dtinv->qty_out		= $oldqqq + $qqq;
		$dtinv->tgl_out     = date('Y-m-d');
		$dtinv->tonase_out	= $oldtns + $ttt;
		$dtinv->update();	
				
		/*update stock tujuan */
		$stk	= Stock::where('brg_id', '=', $tjn)->get();
		
		if ($stk->count()==0){
			$stock = New Stock;
			$stock->brg_id	= $tjn;
			$stock->trf_in	= $qqq;
			$stock->tgl_in	= date('Y-m-d');
			$stock->stock_akhir = $ttt;
			$stock->save();
		}else{
			foreach($stk as $st){ $idstk = $st->id_stock;}
			
			$stock = Stock::find($idstk);
			$stkold = $stock->stock_akhir;
			$trfold	= $stock->trf_in;
			
			$stock->trf_in	= $trfold + $ttt;
			$stock->tgl_in	= date('Y-m-d');
			$stock->stock_akhir	= $stkold + $ttt;
			$stock->update();
		}

	
// insert logs
		$usrnm	= Auth::user()->username;
		
		$userlog = New User_logs;
		$userlog->title		= 'Mutasi Stock';
		$userlog->content	= Product::Product($asl)->nama_brg.' berhasil dimutasi ->'.Product::Product($tjn)->nama_brg.' by.'.$usrnm;
		$userlog->user_id	= Auth::user()->id;
		$userlog->save();	  	  
	   echo json_encode(array('msg'=>'success'));
   }

}
