<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Message;
use Auth;

class MessageController extends Controller
{
	public function index()
	{
		return view('message.index');
	}
	
    public function getMessage()
	{
	    $tglnow = date('Y-m-d');
        $messages   = Message::where('mess_tgl', '=', $tglnow)
                      ->where('read_sts', '=', 0)
                      ->where('mess_user','=', Auth::user()->username)
                      ->OrWhere('mess_user','=', 'ALL')->get();
        
        $data=array();
        foreach($messages as $list){
            $row = array();
            $row[] = tanggal_indonesia($list->mess_tgl);
            $row[] = $list->mess_title;
            $row[] = '<a onclick="showMessage('.$list->id_mess.')" class="btn btn-primary btn-md"><i class="fa fa-envelope-o"></i> Read</a>';
                
            $data[] = $row;
     }

     $output = array("data" => $data);
     return response()->json($output);
    }
 
	function show($id)
	{
	}
	
    function lihat($id){
        $pesan = Message::where('id_mess', $id)->get();
        
        $data = array();
        foreach ($pesan as $list){
            $row = array();
            $row[] = $list->mess_text;
            
            $data[] = $row;
        }
        
        $output = array("data" => $data);
        return response()->json($output);
   }        
   
   function warning(){
       $tglnow = date('Y-m-d');
       $warn = Message::where('mess_tgl', '=', $tglnow)
                        ->where('warn_sts', '=', 0)
                        ->where('mess_user', '=', Auth::user()->username)
                        ->get();
       
       foreach($warn as $list){
            
            $idmess = $list->id_mess;
            
            $row = array();
            $row[1] = $list->mess_title;
            $row[2] = str_replace("<br>"," ", $list->mess_text);
          
            break;
       }
   
     $pesan = Message::find($idmess);
     $pesan->warn_sts = 1;
     $pesan->update();
    
     $output = array("mess_title" => $row[1], "mess_text" => $row[2]);
     return response()->json($output);
     
   }
   
 
}
