<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use DB;
use App\MSPayment;
use App\Cashier;
use App\Outlet;

class MasterController extends Controller
{
    
    public function cashier(){
        $outlet = Outlet::where('company_id', Auth::user()->company_id)
                        ->get();
                        
        return view('master.cashier', compact('outlet'));
    }

    public function dataCashier(){
        $ksr = Cashier::all();
        
        $data=[];
        foreach($ksr as $csr){
            $row=[];
            $row[]=$csr->cashier_name;
            $row[]=tanggal_indonesia($csr->tglkerja, false);
            $row[]=Outlet::getOutlet($csr->outlet_id)->outlet_name;
            $row[] = '<div class="btn-btn">
                        <a onclick="editForm('.$csr->id.')" class="btn btn-danger btn-sm"><i class="fa fa-pencil-square-o"></i> </a>
    			    </div>';
    			    
            $data[]=$row;
        }
        
        $output = ["data"=>$data];
        return response()->json($output);
        
    }
    
    public function simpanCashier(Request $request){
        $ksr = new Cashier;
        $ksr->company_id    = Auth::user()->company_id;
        $ksr->outlet_id     = $request['outlet'];
        $ksr->cashier_name  = $request['nama'];
        $ksr->tglkerja      = $request['tgl'];
        $ksr->password      = $request['psw'];
        $ksr->is_active     = 1;
        $ksr->save();
        
        echo json_encode(["msg"=>"success"]);
    }

    public function editcashier($id){
        $ksr = Cashier::find($id);
        echo json_encode($ksr);
    }

    public function simpaneditcashier(Request $request, $id){
        $ksr = Cashier::find($id);
        
        $ksr->outlet_id     = $request['outlet'];
        $ksr->cashier_name  = $request['nama'];
        $ksr->tglkerja      = $request['tgl'];
        $ksr->password      = $request['psw'];        
        $ksr->update();
        
        echo json_encode(["msg"=>"success"]);
    }
    
/*-----------------------------------------------------*/    
    
    
    
/* master payment */    
    public function index_payment()
    {
		return view('master.index_payment'); 
    }

    public function listPayment(){
        return view('master.list_payment');
    }
    
    public function typePayment(){
	    $dt = MSPayment::where('company_id', Auth::user()->company_id)
	                        ->where('is_active', 1)
	                        ->orderBy('pay_kode','ASC')
							->get();
   
        $data = [];
        foreach($dt as $list){
            
            $row = [];

            $row[] = $list->pay_kode;
            $row[] = $list->pay_name;
            $data[] = $row;
        }

        $output = array("data" => $data);
        return response()->json($output);        
    }
    

    public function dataPayment()
    {
     
	    $dt = MSPayment::where('company_id', Auth::user()->company_id)
	                        ->orderBy('pay_kode','ASC')
							->get();
   
        $no=0;
        $data = [];
        foreach($dt as $list){
            
            if($list->is_active==1){ $sts = '<div label class="label-success">Active</div>'; }else{$sts = '<div label class="label-danger">Non Active</div>';}
            
            $no++;
            $row = [];

            $row[] = $list->pay_kode;
            $row[] = $list->pay_name;
            $row[] = $sts;
            $row[] = '<div class="btn-btn">
               <a onclick="editForm('.$list->id.')" class="btn btn-primary btn-xs"><i class="fa fa-pencil"></i></a>
               </div>';
            $data[] = $row;
        }

     $output = array("data" => $data);
     return response()->json($output);
	 
    }

    public function simpanPayment(Request $request){
        $dt = new MSPayment;
        $dt->company_id = Auth::user()->company_id;
        $dt->pay_kode   = strtoupper($request['kode']);
        $dt->pay_name   = ucwords(strtolower($request['desk']));
        $dt->is_active  = 1;
        $dt->save();
        
        echo json_encode(["msg"=>"success"]);
    }

    public function editPayment($id){
        $dt = MSPayment::find($id);
        echo json_encode($dt);
    }
    
    public function simpaneditPayment(Request $request, $id){
        $dt = Driver::find($id);
        $dt->pay_kode = strtoupper($request['kode']);
        $dt->pay_name = ucwords(strtolower($request['desk']));
        $dt->update();
        echo json_encode(["msg"=>"success"]);
    }




}
