<?php

namespace App\Http\Controllers;

use Mike42\Escpos\Printer;
use Mike42\Escpos\EscposImage;
use Mike42\Escpos\PrintConnectors\RawbtPrintConnector;
use Mike42\Escpos\CapabilityProfile;

use Illuminate\Http\Request;
use App\Product;
use App\DtProduct;
use App\StockProduct;
use App\Driver;
use App\Salesman;
use App\Mobil;
use App\Kanvas;
use App\DtKanvas;
use App\StockKanvas;
use App\KanvasMSale;
use App\KanvasDSale;
use App\Customer;
use App\User;
use App\User_logs;

use Datatables;
use DB;
use Auth;
use Session;

class KanvasController extends Controller
{
	
    public function index()
    {
		$mobil 	= Mobil::where('is_kanvas',0)->get();  
		$driver	= Driver::all()->sortBy('nama');
		$sales	= Salesman::where('kanvas_id',0)->get();
		
		$prd   = DB::table('product_stock as A')
		                ->select('A.product_id','B.nama_brg','B.stn_stock')
		                ->leftjoin('ms_product as B', function($join)
		                    {
		                        $join->on('A.product_id','=', 'B.id');
		                    })
		                ->whereRaw('(A.stock_awal + A.stock_in - A.stock_out - A.stock_sale)>0')
		                ->get();
		

		return view('kanvas.index', compact('mobil','driver', 'sales','prd'));
    }	
    

    public function getData()
    {

     	$kvs = Kanvas::with('get_mobil','get_driver','get_sales')
     	                    ->where('is_closed', 0)
     	                    ->where('is_posted', 0)
     	                    ->get();

        $data = array();
         
        foreach($kvs as $list){
            
            $row = array();
            $row[] = $list->kode;
            $row[] = $list->tanggal;
            $row[] = $list->get_mobil->no_pol;
            $row[] = $list->get_driver->nama;
            $row[] = $list->get_sales->nama;
            $row[] = $list->level_harga;
            $row[] = '<div class="btn-btn">
                        <a onclick="editForm('.$list->id.')" class="btn btn-danger btn-sm"><i class="fa fa-pencil-square-o"></i> Edit Master Kanvas</a>
                        <a onclick="addStock('.$list->id.')" class="btn btn-primary btn-sm"><i class="fa fa-plus"></i> Input Stock Kanvas</a>
    			    </div>';
            $data[] = $row;
         }

         $output = array("data" => $data);
         return response()->json($output);
    }

	
    function pilihdata()
    {
     	 $Produk = Product::leftJoin('ms_category', 'ms_category.id_cat', '=', 'ms_product.cat_id');
	 
		return Datatables::of($Produk)->make(true);
    }	

    public function store(Request $request)
    {
        $kd  = $this->cekKode();
    	$kvs = new Kanvas;
    	$kvs->kode       = $kd;
		$kvs->tanggal    = $request['tgl'];
		$kvs->mobil_id	 = $request['mobil'];
		$kvs->driver_id  = $request['driver'];
		$kvs->sales_id   = $request['sales'];
		$kvs->deskripsi	 = $request['desk'];
		$kvs->level_harga= $request['lvl'];
		$kvs->user_id    = Auth::user()->id;
		$kvs->save();

        $dt = Kanvas::where('kode', $kd)->first();

        $mbl = Mobil::find($request['mobil']);
        $mbl->is_kanvas  =1;
        $mbl->update();
        
        $sls = Salesman::find($request['sales']);
        $sls->kanvas_id = $dt->id;
        $sls->update();
        
	// insert logs
		$usrnm	= Auth::user()->username;
		
		$userlog = New User_logs;
		$userlog->title		= 'Master Kanvas Baru';
		$userlog->content	= 'Kanvas '.$kd.' berhasil dibuat oleh '.$usrnm;
		$userlog->user_id	= Auth::user()->id;
		$userlog->save();

		echo json_encode(array('msg'=>'success'));
        
    }


    public static function cekKode(){
    	/* cek no terakhir */
		$noref	= '';
		$tahun	= date('Y');
		$bulan	= date('m');
		$nomor	="KVS/".$tahun.$bulan."/";  //KVS/202106/001		
			
		$ada_no	= DB::table('ms_kanvas')
						->select(DB::raw('SUBSTR(MAX(kode),12,3) as last_no'))
						->where('kode', 'LIKE', "$nomor%" )
						->first();
			
		if (!empty($ada_no))
		{
			$no	= $ada_no->last_no + 1;
				
			$nomorbaru 	= sprintf("%03s", $no);		//format: IN/202101/0001
			$noref = $nomor.$nomorbaru;
			
		} else {
			$nomorbaru = "001";
			$noref = $nomor.$nomorbaru;
		}
		
		return $noref;
    }
    
    
    public function edit($id)
    {
      $kvs = Kanvas::find($id);
      echo json_encode($kvs);
    }

    public function show($id)
    {
      $kvs = Kanvas::find($id);
      echo json_encode($kvs);
    }


    public function update(Request $request, $id)
    {
		

		
// insert logs
		$usrnm	= Auth::user()->username;
		$userlog = New User_logs;
		$userlog->title		= 'Edit Master Product';
		$userlog->content	= 'Produk '.$request['nama'].' berhasil diedit oleh '.$usrnm;
		$userlog->user_id	= Auth::user()->id;

		$userlog->save();		

        echo json_encode(array('msg'=>'success'));
    }


    public function loadHeader($id){
        $dt = Kanvas::find($id);
        echo json_encode($dt);
    }
    
    /* data detail*/
    public function dataDetail($id){
        
        $dt = DtKanvas::where('kanvas_id', $id)
                            ->get();
                    
        $data=[];            
        foreach($dt as $list){
            
            $prd = Product::find($list->product_id);
 
            $row=[];
            $row[] = $prd->nama_brg;
            $row[] = format_uang($list->qty_kanvas).' '.$prd->stn_stock;

            if($list->is_posted==0){
      		    $row[] = '<div class="btn-btn">
						<a onclick="editDetail('.$list->id.')" class="btn btn-flat btn-xs btn-outline-success" style="margin-top:-4px;margin-bottom:-5px;"><i class="fa fa-pencil"></i></a>
					</div>';  
            }else{
                $row[]="";
            }
            
            $data[]=$row;
        }
        
        $output=["data"=>$data];
        return response()->json($output);
    }
        
    public function simpanDetail(Request $request, $id){
        
        $kvs = Kanvas::find($id);
        
        $qty   = $request['qty'];
        $prd = Product::find($request['prd']);

        $dt = new DtKanvas;
        
        $dt->kanvas_id  = $id;
        $dt->product_id = $request['prd'];
        $dt->qty_kanvas = $qty;
        $dt->save();
        
        
        	// insert logs
			$usrnm	= Auth::user()->username;
			
			$userlog = New User_logs;
			$userlog->title		= 'Stock Kanvas '.$kvs->kode;
			$userlog->content	= 'Stock '.$prd->nama_brg.' berhasil ditambahkan oleh '.$usrnm;
			$userlog->user_id	= Auth::user()->id;
			$userlog->save();
        
        echo json_encode(["msg"=>"success"]);
    }
    
    public function editDetail($id){
        
        $dt = DtKanvas::find($id);
        $prd = Product::find($dt->product_id);
        
        echo json_encode(array_merge(json_decode($prd, true), json_decode($dt,true)));
    }
    
    public function simpanEditDetail(Request $request, $id){
        
        $prd = Product::find($request['prd']);
        $dt  = DtKanvas::find($id);
        $kvs = Kanvas::find($dt->kanvas_id);

        $dt->qty_kanvas    = $request['qty'];
        $dt->update();
        
        
        	// insert logs
			$usrnm	= Auth::user()->username;
			
			$userlog = New User_logs;
			$userlog->title		= 'Edit Detail Kanvas '.$kvs->kode;
			$userlog->content	= 'Stock '.$prd->nama_brg.' berhasil ditambahkan oleh '.$usrnm;
			$userlog->user_id	= Auth::user()->id;
			$userlog->save();
        
        echo json_encode(["msg"=>"success"]);
    }    
    
    public function cetakDokumen($id){
        
        $ms = DB::table('ms_kanvas as A')
                    ->select('A.kode','A.tanggal','B.no_pol','C.nama as driver','D.nama as sales')
                    ->leftjoin('ms_mobil as B', function($join)
                        {
                            $join->on('A.mobil_id','=','B.id');
                        })
                    ->leftjoin('ms_driver as C', function($join)
                        {
                            $join->on('A.driver_id','=','C.id');
                        })
                    ->leftjoin('ms_salesman as D', function($join)
                        {
                            $join->on('A.sales_id', '=', 'D.id');
                        })
                    ->where('A.id',$id)
                    ->first();
                    
        $dt = DtKanvas::leftjoin('ms_product','dt_kanvas.product_id','=','ms_product.id')
                            ->where('dt_kanvas.kanvas_id', $id)
                            ->get();
                            
        $no=1;
        
        return view('kanvas.kanvas_dokumen', compact('ms','dt','no'));
    }
    
    public function postingKanvas($id){
        
        $ms = Kanvas::find($id);
        $kv = DtKanvas::where('kanvas_id', $id)
                    ->get();
        
        foreach($kv as $dt){
            
            $stokprd  = StockProduct::where('product_id', $dt->product_id)->first();
            $oldprd   = $stokprd->stock_out;
            
            $adastock = StockKanvas::where('kanvas_id', $id)
                                        ->where('product_id', $dt->product_id)
                                        ->first();
            
            if(empty($adastock)){
                $stk = new StockKanvas;
                $stk->kanvas_id = $id;
                $stk->product_id= $dt->product_id;
                $stk->stock_in  = $dt->qty_kanvas;  
                $stk->tgl_in    = $ms->tanggal;
                $stk->save();
            }else{
                $old = $adastock->stock_in;
                $adastock->stock_in = $old + $dt->qty_kavas;
                $adastock->tgl_in   = $ms->tanggal;
                $adastock->update();
            }    
            
            /* update stock gudang */
            $stokprd->stock_out = $oldprd + $dt->qty_kanvas;
            $stokprd->update();
        }    
        
        $ms->is_posted=1;
        $ms->update();
        //echo json_encode(["msg"=>"success"]);
                
        Session::flash('sukses','Posting berhasil !');
    	return back();
    }

    public function index_stock(){
        
        $kvs = DB::table('ms_kanvas as A')
                        ->select('A.id','A.kode','A.tanggal','B.no_pol', 'C.nama as driver', 'D.nama as sales')
                        ->leftjoin('ms_mobil as B', 'A.mobil_id','=','B.id')
                        ->leftjoin('ms_driver as C', 'A.driver_id', '=','C.id')
                        ->leftjoin('ms_salesman as D', 'A.sales_id', '=','D.id')
                        ->where('A.is_closed', 0)->get();
                        
        return view('kanvas.index_stock', compact('kvs'));
    }
    
    public function dataStock($id){
        
        
        $dt = DB::table('stock_kanvas as A')
                    ->select('A.id','A.product_id','B.nama_brg','A.stock_awal','A.stock_in','A.stock_out','A.stock_sale','B.stn_stock')
                    ->leftjoin('ms_product as B', function($join)
                        {
                            $join->on('A.product_id','=','B.id');
                        })
                    ->where('A.kanvas_id', $id)
                    ->get();
        
        $data=[];
        foreach($dt as $list){
            $row=[];
            $row[]=$list->nama_brg;
            //$row[]=format_uang($list->stock_awal);
            $row[]=format_uang($list->stock_in);
            $row[]=format_uang($list->stock_out);
            $row[]=format_uang($list->stock_sale);
            $row[]=format_uang($list->stock_awal+$list->stock_in-$list->stock_out-$list->stock_sale).' '.$list->stn_stock;
            $row[]='<div class="btn-btn">
                        <a onclick="stockDetail('.$list->id.')" class="btn btn-success btn-xs"><i class="fa fa-list"></i></a>
                    </div>';
                    
            $data[]=$row;
        }
        
        $output = ["data"=>$data];
        return response()->json($output);
    }

/* penjualan kanvas */

    public function index_sale(){
        $cust = Customer::all();
        $kvs = DB::table('ms_kanvas as A')
                        ->select('A.id','A.kode','A.tanggal','B.no_pol', 'C.nama as driver', 'D.nama as sales')
                        ->leftjoin('ms_mobil as B', 'A.mobil_id','=','B.id')
                        ->leftjoin('ms_driver as C', 'A.driver_id', '=','C.id')
                        ->leftjoin('ms_salesman as D', 'A.sales_id', '=','D.id')
                        ->where('is_posted', 1)
                        ->where('A.is_closed', 0)->get();
                        
        return view('kanvas.kanvas_sale', compact('kvs','cust'));        
    }
    
    public function penjualan($id)
    {
    
     	$kvs = KanvasMSale::with('get_customer')
     	                    ->where('kanvas_id', $id)
     	                    ->where('is_posted',0)
     	                    ->get();

        $data = array();
         
        foreach($kvs as $list){
            
            if($list->type==1){ $tp="KONTAN"; }else{ $tp="KREDIT"; }
            $row = array();

            $row[] = tanggal_indonesia($list->tanggal, false);
            $row[] = $list->no_invoice;
            $row[] = $list->get_customer->cus_name.' / '.$list->get_customer->cus_nohp;
            //$row[] = $tp;
            $row[] = '<div class="btn-btn">
                        <a onclick="addSale('.$list->id.')" class="btn btn-success btn-sm"><i class="fa fa-pencil-square-o"></i></a>
    			    </div>';
            $data[] = $row;
         }

         $output = array("data" => $data);
         return response()->json($output);
    }
	
	public function newInvoice(Request $request, $id){
	    
	    $kvs = Kanvas::find($id);
	    $sls = Salesman::find($kvs->sales_id);
	    
	    $noinv = $this->cekNoInvoice($sls->kode);
	    
	    $dt = new KanvasMSale;
	    $dt->kanvas_id  = $id;
	    $dt->tanggal    = $request['tgl'];
	    $dt->type       = $request['kontankredit'];
	    $dt->no_invoice = $noinv;
	    $dt->cust_id    = $request['cus'];
	    $dt->user_id    = Auth::user()->id;
	    $dt->save();

        $cus = Customer::find($request['cus']);
			
	// insert logs
			$usrnm	= Auth::user()->username;
			
			$userlog = New User_logs;
			$userlog->title		= 'Invoice Baru ';
			$userlog->content	= 'Invoice '.$noinv.' Cust: '.$cus->cus_name.' berhasil dibuat oleh '.$usrnm;
			$userlog->user_id	= Auth::user()->id;
			$userlog->save();
        
        echo json_encode(["msg"=>"success"]);	    
	}
	
    public static function cekNoInvoice($kd){
    	/* cek no terakhir */
		$noref	= '';
		$tahun	= date('Y');
		$bulan	= date('m');
		$nomor	=$kd."/".$tahun.$bulan."/";		
			
		$ada_no	= DB::table('kanvas_msale')
						->select(DB::raw('SUBSTR(MAX(no_invoice),12,4) as last_no'))
						->where('no_invoice', 'LIKE', "$nomor%" )
						->first();
			
		if (!empty($ada_no))
		{
			$no	= $ada_no->last_no + 1;
				
			$nomorbaru 	= sprintf("%04s", $no);		//format: IN/202101/0001
			$noref = $nomor.$nomorbaru;
			
		} else {
			$nomorbaru = "0001";
			$noref = $nomor.$nomorbaru;
		}
		
		return $noref;
    }	
    
    public function kanvasDetail($id){
        
        $dt = KanvasDSale::where('msale_id', $id)->get();
        $data=[];
        foreach($dt as $list){
            $row=[];
            $row[]=Product::Product($list->product_id)->nama_brg;
            $row[]='<div class="text-right">'.format_uang($list->harga).'</div>';
            $row[]='<div class="text-right">'.$list->qty_sale.'</div>';
            $row[]='<div class="text-right">'.format_uang($list->potongan).'</div>';
            $row[]='<div class="text-right">'.format_uang($list->qty_sale * $list->harga - $list->potongan).'</div>';
            $row[] = '<div class="btn-btn">
                        <a onclick="plusSale('.$list->id.')" class="btn btn-success btn-sm"><i class="fa fa-plus"></i></a>
                        <a onclick="minSale('.$list->id.')" class="btn btn-danger btn-sm"><i class="fa fa-minus"></i></a>
                        <a onclick="potSale('.$list->id.')" class="btn btn-primary btn-sm"><i class="fa fa-percent"></i></a>
    			    </div>';
    			    
            $data[]=$row;
            
        }
        
        $output=["data"=>$data];
        return response()->json($output);
    }
    
    public function loadInvoice($id){
        $msale = KanvasMSale::find($id);
        $cust  = Customer::find($msale->cust_id);
        
        echo json_encode(array_merge(json_decode($cust, true), json_decode($msale, true)));
    }
    
    public function loadSummary($id){
        $dt = KanvasDSale::where('msale_id', $id)
                            ->get();
        $tl=0;
        foreach($dt as $list){
            $tl +=$list->qty_sale * $list->harga - $list->potongan;
        }
        
        echo json_encode(["totalsale"=>$tl]);
    }
    
	public function tampilProduct($id, $msl)
	{
	    $ccc=KanvasMSale::find($msl);
	    $cus=Customer::find($ccc->cust_id);
	    
		$dtstock = DB::table('stock_kanvas as A')
		                    ->select('A.id', 'A.product_id','B.nama_brg','A.stock_awal','A.stock_in','A.stock_out','A.stock_sale','B.harga_jual','B.harga_jual2','B.harga_jual3','B.harga_jual4')
		                    ->leftJoin('ms_product as B', 'A.product_id','=', 'B.id')
							->where('A.kanvas_id', $id)
							->get();

				$no=0;
				$data = [];

				foreach($dtstock as $list)
				{
					$row = [];	 
					$no++;
					
					$harga = $list->harga_jual;
					switch($cus->cus_level){
					    case '2': $harga= $list->harga_jual2; break;
					    case '3': $harga= $list->harga_jual3; break;
					    case '4': $harga= $list->harga_jual4; break;
					}
					
					$stk = $list->stock_awal+$list->stock_in-$list->stock_out-$list->stock_sale;
					
					//$row[] = $no;
					$row[] = $list->nama_brg;
					$row[] = format_uang($harga);
					$row[] = format_uang($stk);
					$row[] = '<div class="btn-btn">
						<a onclick="selectItem('.$list->id.')" class="btn btn-primary btn-sm"><i class="fa fa-check"></i></a></td>
						  </div>';
						  
					$data[] =$row;
				}

			$output = array("data" => $data);
			return response()->json($output);

	}
    
    public function simpanSale(Request $request){
        $idprd  = $request['kode'];
        $msl    = $request['id_msale'];
        $kvs    = KanvasMSale::find($msl);
        $prd    = Product::find($idprd);
        $cus    = Customer::find($kvs->cust_id);

		$harga = $prd->harga_jual;
		switch($cus->cus_level){
		    case '2': $harga= $prd->harga_jual2; break;
		    case '3': $harga= $prd->harga_jual3; break;
		    case '4': $harga= $prd->harga_jual4; break;
		}

        $dt = new KanvasDSale;
        $dt->msale_id   = $msl;
        $dt->product_id = $idprd;
        $dt->harga      = $harga;
        $dt->qty_sale   = 1;
        $dt->save();
        
        /*update stock */
        
        $stkvs = StockKanvas::where('kanvas_id', $kvs->kanvas_id)
                                ->where('product_id',$idprd)
                                ->first();
        $aa = $stkvs->stock_sale;
        $stkvs->stock_sale  = $aa + 1;
        $stkvs->tgl_sale    = date('Y-m-d');
        $stkvs->update();
        
        echo json_encode(["msg"=>"success"]);
    }
    
    public function potongan($id){
        $dt = KanvasDSale::find($id);
        $prd= Product::find($dt->product_id);
        
        echo json_encode(array_merge(json_decode($prd, true), json_decode($dt, true)));
    }
    
    public function updStock($idkvs, $idprd, $mode){
        $stkvs = StockKanvas::where('kanvas_id', $idkvs)
                                ->where('product_id',$idprd)
                                ->first();
        $aa = $stkvs->stock_sale;
        if($mode==1){
            $stkvs->stock_sale = $aa + 1;
        }else{
            $stkvs->stock_sale = $aa - 1;
        }
        
        $stkvs->tgl_sale = date('Y-m-d');
        $stkvs->update();        
    }
    
    public function updQty($id, $mode){
        $dt = KanvasDSale::find($id);
        $kvs = KanvasMSale::find($dt->msale_id);
        
        if ($mode=='1'){
            $dt->qty_sale  += 1;
        }else{
            if ($dt->qty_sale>0){ 
                $dt->qty_sale  -= 1; 
            }else{
                return false;
            }
        }
        
        $dt->update();
        $this->updStock($kvs->kanvas_id,$dt->product_id, $mode);
        
        echo json_encode(["msg"=>"success"]);
    }
    
    public function simpanPotongan(Request $request,$id){
        
        $dt = KanvasDSale::find($id);
        $dt->potongan   = $request['pot'];
        $dt->update();
        
        echo json_encode(["msg"=>"success"]);
    }
    
	public function cetakInvoice($id)
	{
		
		$msale		= KanvasMSale::find($id);
		$dsale	 	= KanvasDSale::leftjoin('ms_product', 'kanvas_dsale.product_id', 'ms_product.id')
									->where('kanvas_dsale.msale_id', $id)
									->get();
		$tlqty=0;
		$totalrp=0;
		
		foreach($dsale as $list){
			$tlqty += $list->qty_sale;
			$totalrp += ($list->qty_sale * $list->harga - $list->potongan);
		}

		$customer	= Customer::find($msale->cust_id);
		$no 	= 1;
     
	 	return view('kanvas.invoice', compact('msale','dsale','no','customer', 'tlqty', 'totalrp')); 
    } 	    
    
    public function postingSale($id){
        
        $msl = KanvasMSale::find($id);
        $dsl = KanvasDSale::where('msale_id', $id)
                            ->get();
        $lns=0;
        if($msl->type==1){ $lns=1; }    /* jika type kontan otomatis lunas */
        
        $tlsale=0;
        foreach($dsl as $dt){
            $tlsale += ($dt->qty_sale * $dt->harga - $dt->potongan);
        }
        
        $msl->total = $tlsale;
        $msl->is_posted = 1;
        $msl->is_lunas  = $lns;
        $msl->update();
        
        return back();
    }
    
    public function jurnalKanvas(){
        return view('kanvas.jurnal');
    }
    
    public function tampilJurnal($tgl1, $tgl2){
        $dt = KanvasMSale::whereBetween('tanggal',[$tgl1, $tgl2])
                                ->get();
        
        $data=[];                                
        foreach($dt as $list){
            
            if($list->type==1){ $tp="KONTAN"; }else{ $tp="KREDIT"; }
            if($list->is_lunas==0){ $sts=""; }else{$sts='<div class="label label-success">LUNAS</label>'; }
            $kvs=Kanvas::find($list->kanvas_id);
            
            $row=[];
            $row[]=$list->tanggal;
            $row[]=$list->no_invoice;
            $row[]=Customer::Customer($list->cust_id)->cus_name;
            $row[]='<div class="text-right">'.format_uang($list->total).'</div>';
            $row[]=Salesman::getSales($kvs->sales_id)->nama;
            $row[]=$tp;
            $row[]=$sts;
            $row[]='<a onclic="showDetail('.$list->id.')" class="btn btn-succes bts-xs"><i class="fa fa-list"></i></a>';
            
            $data[]=$row;
            
        }
    
        $output=["data"=>$data];
        return response()->json($output);     
    }
    
    public function pelunasan(){
        return view('kanvas.pelunasan');
    }
    
    public function index_cicilan(){
        return view('kanvas.index_cicilan');
    }
    
    public function cicilan()
    {
    
     	$kvs = KanvasMSale::with('get_customer')
     	                    ->where('is_posted',1)
     	                    ->where('is_lunas',0)
     	                    ->get();

        $data = [];
         
        foreach($kvs as $list){
            
            $row = [];

            $row[] = tanggal_indonesia($list->tanggal, false);
            $row[] = $list->no_invoice;
            $row[] = $list->get_customer->cus_name.' / '.$list->get_customer->cus_nohp;
            $row[] = '<div class="text-right">'.format_uang($list->total).'</div>';
            $row[] = '<div class="text-right">'.format_uang($list->cicilan).'</div>';
            $row[] = '<div class="text-right">'.format_uang($list->total-$list->cicilan).'</div>';
            $row[] = '<div class="btn-btn">
                        <a onclick="addCicilan('.$list->id.')" class="btn btn-success btn-sm"><i class="fa fa-pencil-square-o"></i></a>
                        <a onclick="listCicilan('.$list->id.')" class="btn btn-primary btn-sm"><i class="fa fa-list"></i></a>
    			    </div>';
            $data[] = $row;
         }

         $output = array("data" => $data);
         return response()->json($output);
    }
    
    public function testprinter(){
        return view('kanvas.testprinter');
    }
    
    public function print_go(){
        
        try {
            $profile = CapabilityProfile::load("POS-5890");
        
            /* Fill in your own connector here */
            $connector = new RawbtPrintConnector();
        
            /* Information for the receipt */

            /* Date is kept the same for testing */
        // $date = date('l jS \of F Y h:i:s A');
            $date = "Monday 6th of April 2015 02:56:25 PM";
        
            /* Start the printer */
//            $logo = EscposImage::load("resources/rawbtlogo.png", false);
            $printer = new Printer($connector, $profile);
        
        
            /* Print top logo */

            /* Name of shop */
            $printer->setJustification(Printer::JUSTIFY_CENTER);
            $printer->selectPrintMode(Printer::MODE_DOUBLE_WIDTH);
            $printer->text("ExampleMart Ltd.\n");
            $printer->selectPrintMode();
            $printer->text("Shop No. 42.\n");
            $printer->feed();
        
        
            /* Title of receipt */
            $printer->setEmphasis(true);
            $printer->text("SALES INVOICE\n");
            $printer->setEmphasis(false);
        
            /* Items */
            $printer->setJustification(Printer::JUSTIFY_LEFT);
            $printer->setEmphasis(true);
            $printer->text("test pertmaa\n");
            $printer->text("test kedua\n");
            $printer->text("test ketiga\n");
            $printer->setEmphasis(false);
            $printer->feed();
        
             /* Footer */
            $printer->feed(2);
            $printer->setJustification(Printer::JUSTIFY_CENTER);
            $printer->text("Thank you for shopping\n");
            $printer->text("at ExampleMart\n");
            $printer->text("For trading hours,\n");
            $printer->text("please visit example.com\n");
            $printer->feed(2);
            $printer->text($date . "\n");
        
            /* Barcode Default look */
        
            $printer->barcode("ABC", Printer::BARCODE_CODE39);
            $printer->feed();
            $printer->feed();
        
        
        // Demo that alignment QRcode is the same as text
            $printer2 = new Printer($connector); // dirty printer profile hack !!
            $printer2->setJustification(Printer::JUSTIFY_CENTER);
            $printer2->qrCode("https://rawbt.ru/mike42", Printer::QR_ECLEVEL_M, 8);
            $printer2->text("rawbt.ru/mike42\n");
            $printer2->setJustification();
            $printer2->feed();
        
        
            /* Cut the receipt and open the cash drawer */
            $printer->cut();
            $printer->pulse();
        
        } catch (Exception $e) {
            echo $e->getMessage();
        } finally {
            $printer->close();
        }
        
    }
	    
}
