<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Product;
use App\Supplier;
use App\Invoice;
use App\InvoiceDetail;
use App\Stock;
use App\User_logs;
use Datatables;
use DB;
use Auth;
Use Redirect;

class InvoiceDetailController extends Controller
{

	public function index()
	{
		return view('invoice_detail.index');
	}
	
   public function listData()
   {
		$minv	= Invoice::find(session('idinv'));
		
		$ppn	= $minv->inv_ppn;
		$disc1	= $minv->inv_disc;
			
		$dtinvoice	= InvoiceDetail::leftJoin('ms_product', 'dt_invoice.id_brg', '=', 'ms_product.id')
										->where('dt_invoice.invoice_id', session('idinv'))->get();
										
				
		$no=0;
		$totalinv1	= 0;
		$totalinv	= 0;
		$disc1	 	= 0;
		$disc2		= 0;
		$disc3		= 0;
			
		$last_no	= 0;
		$data = array();
				
		foreach($dtinvoice as $list){
			$no++;
			$jlh 	= ($list->inv_gross*$list->tonase_vol)+($list->inv_gross*$list->inv_qty*$list->inv_isi);
		
			$jumlahinv	= $jlh - $disc1;
			
			$isi    = $list->inv_isi + $list->tonase_vol;
			$row = array();
				
			$row[] = $no;
			$row[] = $list->nama_brg;
			$row[] = '<div class="text" align="right">'.format_uang($list->inv_gross).'</div>';
			$row[] = $list->inv_qty;
			$row[] = '<div class="text" align="right">'.$isi.'</div>';
			$row[] = $list->tonase_stn;
			$row[] = '<div class="text" align="right">'.format_uang($jumlahinv).'</div>';
			
			if(Auth::user()->beli_del==1){
				$row[] = '<div class="btn-btn">
					<a onclick="editForm('.$list->id_inv.')" class="btn btn-primary btn-sm"><i class="fa fa-pencil"></i></a>
					<a onclick="deleteItem('.$list->id_inv.')" class="btn btn-danger btn-sm"><i class="fa fa-trash"></i></a>
					</div>';
			}else{
				$row[] = '<div class="btn-btn">
					<a onclick="editForm('.$list->id_inv.')" class="btn btn-primary btn-sm"><i class="fa fa-pencil"></i></a>
					<a onclick="error_mess()" class="btn btn-default btn-sm"><i class="fa fa-trash"></i></a>
					</div>';	
			}

			$data[] = $row;		

			}
				
		$no++;

		$output = array("data" => $data);
		return response()->json($output);
	}
			
////////////////////////////////////////////////////////////////////////


    public function loadSummary(){
        
		$dtinv	= InvoiceDetail::where('invoice_id', session('idinv'))->get();
		
		$totalinv=0;
		$totalqty=0;
										
        foreach($dtinv as $list){
            if($list->type_brg==1){
                $totalinv += $list->inv_gross * $list->inv_qty * $list->inv_isi;
            }else{
                $totalinv += $list->inv_gross * $list->tonase_vol;
            }
            $totalqty += $list->inv_qty;
        }
        
        $invoice = Invoice::find(session('idinv'));
        $invoice->inv_total = $totalinv;
        $invoice->update();
        
        $data = array("totalqty"=>format_uang($totalqty),
                      "totalrp" =>format_uang($totalinv));
                      
        return response()->json($data);
    }

 
///-- add item ----------------------------------------------------- yg sebelumnya */
	public function store(Request $request)
	{
		$idinv		= $request['idinv'];
		$idlist		= $request['kode'];
		
		$inv        = Invoice::find($idinv);
		
		$product	= Product::find($idlist);

		$invdetail	= New InvoiceDetail;
		$invdetail->invoice_id	= $idinv;
		$invdetail->id_brg		= $product->id;
		$invdetail->inv_gross	= 0;    //$product->harga_list;
		$invdetail->inv_qty		= 1;		//default qty
		$invdetail->inv_disc1	= 0;		//default disc1
		$invdetail->inv_stn		= "";
		$invdetail->type_brg    = $product->type_brg;
		$invdetail->inv_tgl     = $inv->inv_tgl;

		$invdetail->user_id	= Auth::user()->id;
		
		$invdetail->save();

	// insert logs
			$usrnm	= Auth::user()->username;
			
			$userlog = New User_logs;
			$userlog->title		= 'Input detail Invoice '.$inv->inv_no;
			$userlog->content	= $product->nama_brg.' berhasil ditambahkan oleh '.$usrnm;
			$userlog->user_id	= Auth::user()->id;
			$userlog->save();

			echo json_encode(array('msg'=>'success'));
			       			
	}
	
    public function destroy($id)
    {
        $dtinv = InvoiceDetail::find($id);
        $dtinv->delete();
        
        echo json_encode(array('msg' => 'success'));
    }
/*----------------------------------------------------------------*/
	public function store__(Request $request)
	{
		$idinv		= $request['id_inv'];
		$idlist		= $request['idbrg'];
		$serial		= $request['noseri_'];
		$disc1		= $request['disc1_'];
		$qty		= $request['qty_'];
		
		$product	= Product::find($idlist);
		$kode		= $product->kode_brg;
			
		//$ada_inv	= InvoiceDetail::where('invoice_id',$idinv)
		//							->where('id_brg', $idlist)
		//							->where('no_seri', $serial)
		//							->count();
		
		//if ($ada_inv>0)
		//{
		//	echo json_encode(array('msg'=>'error'));
		//}
		
		$invdetail	= New InvoiceDetail;
		
		$invdetail->invoice_id	= $idinv;
		$invdetail->id_brg		= $product->id;
		$invdetail->inv_gross	= $product->harga_list;
		$invdetail->inv_qty		= $qty;			//default qty
		$invdetail->inv_disc1	= $disc1;		//default disc1
		$invdetail->no_seri		= $serial;
		$invdetail->inv_stn		= "PCS";

		$invdetail->user_id	= Auth::user()->id;
		
		$invdetail->save();

	// insert logs
			$usrnm	= Auth::user()->username;
			
			$userlog = New User_logs;
			$userlog->title		= 'Input detail Invoice';
			$userlog->content	= 'KODE '.$kode.' berhasil ditambahkan oleh '.$usrnm;
			$userlog->user_id	= Auth::user()->id;
			$userlog->save();

			echo json_encode(array('msg'=>'success'));
			       			
	}


/*-------------------------------------------------------------------*/
	public function show($id)
	{
		//$dtinv = InvoiceDetail::find($id);
		$barang = Product::find($id);
	 
		echo json_encode($barang);		
	}
	
    public function edit($id)
    {
      $dtinv = InvoiceDetail::find($id);
	  $barang = Product::find($dtinv->id_brg);
	  echo json_encode(array_merge(json_decode($barang, true),json_decode($dtinv, true)));
	 
    }

    public function caribrg($id)
    {
	  $barang = Product::find($id);
	 
	  echo json_encode($barang);
    }
////////////////
	
    public function update(Request $request, $id)		
    {
		$dtinv 		= InvoiceDetail::find($id);
		$product	= Product::find($dtinv->id_brg);
		$tp         = $product->type_brg;
		$inv        = Invoice::find($dtinv->invoice_id);
		
		if($tp==1){
    		$dtinv->inv_gross   = $request['gross'];		
    		$dtinv->inv_qty 	= $request['qty'];
    		$dtinv->inv_isi		= $request['isi'];
    		$dtinv->tonase_vol  = 0;
    		$dtinv->inv_stn     = $request['satuan'];
    		$dtinv->user_id	 	= Auth::user()->id; 
     		$dtinv->update();
		}else{
    		$dtinv->inv_gross   = $request['gross'];		
    		$dtinv->inv_qty 	= $request['qty'];
    		$dtinv->tonase_vol	= $request['isi'];
    		$dtinv->inv_isi     = 0;
    		$dtinv->tonase_stn  = $request['satuan'];
    		$dtinv->user_id	 	= Auth::user()->id; 
     		$dtinv->update();		    
		}
		
// insert logs
		$usrnm	= Auth::user()->username;
		$userlog = New User_logs;
		$userlog->title		= 'Edit Detail Invoice '.$inv->inv_no;
		$userlog->content	= $product->nama_brg.' berhasil diedit oleh '.$usrnm;
		$userlog->user_id	= Auth::user()->id;
		$userlog->save();		

        echo json_encode(array('msg'=>'success'));
    }
	
	public function printForm()
	{
		
		$minv		= Invoice::find(session('idinv'));
		
		$dinv	 	= InvoiceDetail::leftjoin('ms_product', 'dt_invoice.id_brg', 'ms_product.id')
									->where('dt_invoice.invoice_id', '=', session('idinv'))
									->get();
								
									
		$supplier	= Supplier::find($minv->supp_id);

		$no 		= 1;

     
	 	return view('invoice_detail.printinv', compact('minv','dinv','no','supplier')); 
   } 	
   
/*  reprint po */
	public function reprintForm()
	{
		
		$minv		= Invoice::find(session('idinv'));
		
		$dinv	 	= InvoiceDetail::leftjoin('ms_product', 'dt_invoice.id_brg', 'ms_product.id')
									->where('dt_invoice.invoice_id', '=', session('idinv'))
									->get();
								
									
		$supplier	= Supplier::find($minv->supp_id);

		$no 		= 1;

	 	return view('invoice_detail.reprintinv', compact('minv','dinv','no','supplier')); 
   } 	   
	
   public function listData2()
   {
		$minv	= Invoice::find(session('idinv'));
		
		$ppn	= $minv->inv_ppn;
		$disc1	= $minv->inv_disc;
			
		$dtinvoice	= InvoiceDetail::leftJoin('ms_product', 'dt_invoice.id_brg', '=', 'ms_product.id')
										->where('dt_invoice.invoice_id', session('idinv'))->get();
										
				
		$no=0;
		$totalinv1	= 0;
		$totalinv	= 0;
		$disc1	 	= 0;
		$disc2		= 0;
		$disc3		= 0;
			
		$last_no	= 0;
		$data = array();
				
		foreach($dtinvoice as $list){
			$no++;
			$jlh 	= ($list->inv_gross*$list->tonase_vol)+($list->inv_gross*$list->inv_qty*$list->inv_isi);
		
			$jumlahinv	= $jlh - $disc1;
			
			$isi    = $list->inv_isi + $list->tonase_vol;
			$row = array();
				
			$row[] = $no;
			$row[] = $list->nama_brg;
			$row[] = '<div class="text" align="right">'.format_uang($list->inv_gross).'</div>';
			$row[] = $list->inv_qty;
			$row[] = '<div class="text" align="right">'.$isi.'</div>';
			$row[] = $list->tonase_stn;
			$row[] = '<div class="text" align="right">'.format_uang($jumlahinv).'</div>';

			$data[] = $row;		

			}
				
		$no++;

		$output = array("data" => $data);
		return response()->json($output);
	}
				
	
}	
