<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Product;
use App\Supplier;
use App\Stock;
use App\Invoice;
use App\InvoiceDetail;
use App\User_logs;
use Datatables;
use DB;
use Auth;
Use Redirect;

class InvoiceController extends Controller
{

	public function index()
	{		
		$supplier = Supplier::orderBy('sup_nama', 'ASC')->get();
		
		return view('invoice.index', compact('supplier'));
	}
	
	public function history()
	{		
		$supplier = Supplier::all();
		
		return view('invoice.history', compact('supplier'));
	}	

//------------------------------history detail


    function getheader()
    {
		$tglnow = date("Y-m-d");

     	$invoice = Invoice::leftjoin('ms_supp', 'ms_invoice.supp_id','=','ms_supp.id_supp')
								->where('ms_invoice.inv_posted',0)
								->where('ms_invoice.inv_batal',0)
								->orderBy('ms_invoice.supp_id','ASC')
								->orderby('ms_invoice.inv_no','ASC')->get();
		
		$no=1;
		$data = array();
		
		foreach($invoice as $list)
		{
			$row = array();
				   
			$row[] = $no++;
			$row[] = $list->inv_no;
			$row[] = tanggal_indonesia($list->inv_tgl, false);
			$row[] = $list->sup_nama." /".$list->sup_kota;
			$row[] = '<div class="text" align="right">'.format_uang($list->inv_total).'</div>';
			$row[] = $list->keterangan;
		    $row[] = '<div class="btn-btn">
				   <a href="invoice/'.$list->id_invoice.'/input" class="btn btn-success btn-xs"><i class="fa fa-plus"> </i></a>
				   <a onclick="editForm('.$list->id_invoice.')" class="btn btn-info btn-xs"><i class="fa fa-pencil"> </i></a>
				   <a onclick="batalForm('.$list->id_invoice.')" class="btn btn-danger btn-xs"><i class="fa fa-times"> </i></a>
				   </div>';	

		   $data[] = $row;
		}

		$output = array("data" => $data);
		return response()->json($output);								
			
    }
/*------------------------------------------------------*/
    function history_header()
    {

     	$invoice = Invoice::leftjoin('ms_supp', 'ms_invoice.supp_id','=','ms_supp.id_supp')
								->where('ms_invoice.inv_posted',1)
								->orWhere('ms_invoice.inv_batal',1)
								->orderby('ms_invoice.inv_tgl','DESC')->get();
		

		$data = array();
		
		foreach($invoice as $list)
		{
			$row = [];
			
			if($list->inv_batal==1){ $ket="BATAL"; }else{ $ket=$list->keterangan;}
			
			$row[] = $list->inv_tgl;
			$row[] = $list->inv_no;
			$row[] = $list->sup_nama." /".$list->sup_kota;
			$row[] = '<div class="text" align="right">'.format_uang($list->inv_total).'</div>';
			$row[] = $ket;
			
			$sss= $list->inv_lunas;
			$sts="";
				switch ($sss){
					case '0': $sts = 'Blm Lunas'; break;
					case '1': $sts = 'LUNAS'; break;}

			//$row[] = $sts;
			$row[] = '<div class="btn-btn">
				   <a href="'.$list->id_invoice.'/tampil" class="btn btn-success btn-xs"><i class="fa fa-list"> </i></a>
				   <a href="'.$list->id_invoice.'/reprint" class="btn btn-danger btn-xs"><i class="fa fa-print"></i></a>
				   </div>';	
		   $data[] = $row;
		}

		$output = array("data" => $data);
		return response()->json($output);								
			
    }

///-- create new invoice
	public function store(Request $request)
	{
		$idsup		= $request['supl'];
		$tglinv		= $request['tglinv'];
		$noinv		= $request['inv'];

		$supplier	= Supplier::find($idsup);
	
		$invoice	= New Invoice;
		$invoice->inv_no	= $noinv;
		$invoice->supp_id	= $idsup;
		$invoice->inv_tgl	= $tglinv;
		$invoice->inv_jt    = $tglinv;
		$invoice->inv_disc	= 0;
		$invoice->keterangan= $request['note'];
		$invoice->user_id	= Auth::user()->id;
		
		$invoice->save();

	// insert logs
			$usrnm	= Auth::user()->username;
			
			$userlog = New User_logs;
			$userlog->title		= 'Invoice Baru';
			$userlog->content	= 'Invoice No.'.$noinv.' '.$supplier->sup_nama.' berhasil dicreate oleh '.$usrnm;
			$userlog->user_id	= Auth::user()->id;
			$userlog->save();

			echo json_encode(array('msg'=>'success'));
			       			
	}

//-------------------------------
	function input($id)
	{
		session(['idinv'=>$id]);
		
		$idinv	    = $id;
		$invoice	= Invoice::where('id_invoice',$id)->get();
		
		foreach($invoice as $list)
		{
			$idsupp	= $list->supp_id;
			$noinv	= $list->inv_no;
		//	$ppn	= $list->inv_ppn;
		//	$disc1	= $list->inv_disc;
			$posted	= $list->inv_posted;
		}
		
		if($posted==1)
		{
			//return Redirect::route('invoice.index');	
			$supplier = Supplier::all();
			return view('invoice.index', compact('supplier'));
		}else{
		
    		$no=1;
    		$m_inv		= Invoice::find($id);
    		$supplier	= Supplier::find($idsupp);
    		if($idsupp != 0){
    		    $product	= Product::where('supplier',$idsupp)
    								->orderBy('nama_brg','ASC')->get();
    		}else{
    		    $product	= Product::orderBy('nama_brg','ASC')->get();
    		}
    
    		return view('invoice_detail.index', compact('m_inv','supplier','product','idinv','no'));
		}
	
	} 

  
/*-----------------------------------------------------*/
	function tampil($id)
	{
		session(['idinv'=>$id]);
		
		$idinv	    = $id;
		$invoice	= Invoice::where('id_invoice',$id)->get();
		
		foreach($invoice as $list)
		{
			$idsupp	= $list->supp_id;
			$noinv	= $list->inv_no;
			$ppn	= $list->inv_ppn;
			$disc1	= $list->inv_disc;
			$posted	= $list->inv_posted;
		}
		
		$no=1;
		$m_inv		= Invoice::find($id);
		$supplier	= Supplier::find($idsupp);
		$product	= Product::where('supplier',$idsupp)
    								->orderBy('nama_brg','ASC')->get();
    	
    
		return view('invoice_detail.index_history', compact('m_inv','supplier','product','idinv','no'));

	} 
/*-----------------------------------------------------*/
    public function edit($id)
    {
      $inv = Invoice::find($id);
      echo json_encode($inv);
    }
    
    public function simpanEdit(Request $request, $id){
        
        $invoice = Invoice::find($id);
   
        $invoice->inv_no    = $request['inv'];
		$invoice->inv_tgl	= $request['tglinv'];
		$invoice->keterangan= $request['note'];
		$invoice->user_id	= Auth::user()->id;

		$invoice->update();

	// insert logs
			$usrnm	= Auth::user()->username;
			
			$userlog = New User_logs;
			$userlog->title		= 'EDIT Invoice';
			$userlog->content	= 'Invoice No.'.$request['inv'].' berhasil diedit oleh '.$usrnm;
			$userlog->user_id	= Auth::user()->id;
			$userlog->save();

			echo json_encode(array('msg'=>'success'));
			       		
    }
    
    public function batal($id){
        
        $invoice = Invoice::find($id);
        
        $invoice->inv_batal = 1;
		$invoice->user_id	= Auth::user()->id;

		$invoice->update();

	// insert logs
			$usrnm	= Auth::user()->username;
			
			$userlog = New User_logs;
			$userlog->title		= 'BATAL Invoice';
			$userlog->content	= 'Invoice No.'.$invoice->inv_no.' berhasil dibatalkan oleh '.$usrnm;
			$userlog->user_id	= Auth::user()->id;
			$userlog->save();

			echo json_encode(array('msg'=>'success'));
    }
    
/* 
    public function show($id)
    {
        
    }
*/

/////////////////////////////////////////////////////////////////////////

	/* posting invoice ke stock & cetak invoice */
	
    public function update($id)
    {

		$invoice 	= Invoice::find($id);
		$noinv      = $invoice->inv_no;
		
		$dtinv  	= InvoiceDetail::where('invoice_id', $id )->get();

		$totalinv	= 0;
		$disc1	 	= 0;
		$total_net	= 0;
		$pokok      = 0;
		
		foreach($dtinv as $list){
            
            $id_detail  = $list->id_inv;
            $idbrg  = $list->id_brg;
            $tglinv = $list->inv_tgl;
            $qty    = $list->inv_qty*$list->inv_isi;
            $isi    = $list->inv_isi;
            $posted = $list->inv_posted;
            $type   = $list->type_brg;
            
			$pokok  = $list->inv_gross;
			$totalinv += ($list->inv_gross * $list->inv_qty * $list->inv_isi)+($list->inv_gross*$list->tonase_vol);

			
			/* posting stock */
			if($type==1){
    			$data_stock  = Stock::where('brg_id', $idbrg)
    			                    ->get();
    			                    
    			$ada_stock   = $data_stock->count();
    			 
    			 if ($ada_stock==0)
    			 {
    			     if ($posted==0){
        			     /* insert stock */
        			     $stock = New Stock;
        			     
        			     $stock->brg_id         = $idbrg;
        			     $stock->barang_masuk   = $qty;
        			     $stock->tgl_masuk      = $tglinv;
        			     $stock->stock_akhir    = $qty;
        			     $stock->user_id        = Auth::user()->id;
    			     
    			         $stock->save();
    			     }
    			     
    			 }else{
    			     
    			     if ($posted==0){			     
        			     /*update stock */
        			     foreach ($data_stock as $dtstock)
        			     { 
        			        $stkakhir   = $dtstock->stock_akhir;
        			        $idstock    = $dtstock->id_stock; 
        			        $masuk      = $dtstock->barang_masuk;
        			     }
        			     
        			     $dt_stock = Stock::find($idstock);
        			     
        			     $dt_stock->barang_masuk  = $masuk + $qty;
        			     $dt_stock->tgl_masuk     = $tglinv;
        			     $dt_stock->stock_akhir   = $stkakhir + $qty;
        			     
    			        $dt_stock->update();
    			     } 
    			 }
    			 
			}

            /*update status posted inv detail */
            $det_inv = InvoiceDetail::find($id_detail);
            $det_inv->inv_posted = 1;
            $det_inv->inv_pokok  = $pokok;
            $det_inv->update();
            
 
		 }
		 
		 /* update ms_invoice */
		 
		 $invoice->inv_total	= $totalinv;
		 $invoice->inv_posted   = 1;
		 $invoice->update();


 		return Redirect::route('invoicedetail.cetak');					//cetak invoice
    }

/* reprint inv */
    public function reprint($id)
    {
		session(['idinv'=>$id]);
		return Redirect::route('invoicedetail.reprint');				//cetak po
    }

	
}
