<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\User;
use App\Hutang;
use App\HutangDetail;
use App\Suppler;
use App\Invoice;
use App\User_logs;
use Datatables;
use DB;
use Auth;
Use Redirect;

class HutangController extends Controller
{

	public function index()
	{		

		$supplier = Supplier::orderBy('sup_nama', 'ASC')->get();
		return view('hutang.index', compact('supplier'));
	}
	
    function getheader()
    {
		$tglnow = date("Y-m-d");

     	$piutang = Piutang::where('sts_posted','=', 0)
     	                    ->where('sts_batal', '=', 0)
							->get();
		
		$no=1;
		$data = array();
		
		foreach($piutang as $list)
		{
			$row = array();
			
			$tp='';
			switch ($list->lunas_type)
			{
				case 1: $tp="CASH"; break;
				case 2: $tp="Transfer/Giro"; break;
				case 3: $tp="Lain2"; break;
			}
				   
			$row[] = tanggal_indonesia($list->lunas_tgl, false);
			$row[] = Customer::Customer($list->cust_id)->cus_name;
			$row[] = '<div class="text" align="right">'.format_uang($list->total_bayar).'</div>';
			$row[] = '<div class="text-bold" align="right">'.format_uang($list->lunas_total).'</div>';
			$row[] = '<div class="text-bold" align="right">'.format_uang($list->pembulatan).'</div>';
			$row[] = $tp;
			$row[] = $list->lunas_notes;
			$row[] = User::NamaUser($list->user_id)->username;
			
			if(Auth::user()->group=="MANAGER"){
    		    $row[] = '<div class="btn-btn">
    				   <a href="piutang/'.$list->id_piutang.'/input" class="btn btn-success btn-sm"><i class="fa fa-plus"> </i></a>
    				   <a onclick="editHeader('.$list->id_piutang.')" class="btn btn-primary btn-sm"><i class="fa fa-pencil"> </i></a>
    				   <a onclick="batal('.$list->id_piutang.')" class="btn btn-danger btn-sm"><i class="fa fa-times"> </i></a>				   
    				   </div>';	
			}else{
                $row[] = '<div class="btn-btn">
				        <a href="piutang/'.$list->id_piutang.'/input" class="btn btn-success btn-sm"><i class="fa fa-plus"> </i></a>
    				   <a onclick="editHeader('.$list->id_piutang.')" class="btn btn-primary btn-sm"><i class="fa fa-pencil"> </i></a>
    				   
    				   </div>';				    
			}

		   $data[] = $row;
		}

		$output = array("data" => $data);
		return response()->json($output);								
			
    }

///-- create new header
	public function store(Request $request)
	{
		$idcust		= $request['cus'];
		$tgltrx		= $request['tgltrx'];
		$ket		= $request['ket'];
		$ttl		= $request['ttl'];
		$blt        = $request['bulat'];
			
		$trans	= New Piutang;
			
		$trans->cust_id	        = $idcust;
		$trans->lunas_tgl	    = $tgltrx;
		$trans->total_bayar		= $ttl;
		$trans->pembulatan      = $blt;
		$trans->lunas_type      = $request['tp'];	
		$trans->lunas_notes     = $ket;
		$trans->user_id	    	= Auth::user()->id;
			
		$trans->save();

		echo json_encode(array('msg'=>'success'));
			       			
	}

//-------------------------------
	function input($id)
	{
		session(['idtrx'=>$id]);
		
		$idtrx	    = $id;
		$trans		= Piutang::where('id_piutang',$id)->get();
		
		foreach($trans as $list)
		{
			$idcust	= $list->cust_id;
		}
		
    		$no=1;
    		$m_piutang		= Piutang::find($idtrx);
    		$customer		= Customer::find($idcust);
    		
             //query data invoice yg belum lunas
            $m_sale = Penjualan::where('ms_sale.cust_id', '=', $idcust)
                                    ->where('ms_sale.sale_lunas', '=', 0)
									->where('ms_sale.sale_posted', '=', 1)
                                    ->get();
            
    		return view('piutang.inputdetail', compact('m_sale','customer', 'idtrx','m_piutang', 'no'));
			
	} 

	public function listData()
	{
		$piutang		= Piutang::find(session('idtrx'));
		
		$dttrans	 	= PiutangDetail::leftJoin('ms_piutang', 'dt_piutang.piutang_id', '=', 'ms_piutang.id_piutang')
										->where('dt_piutang.piutang_id', session('idtrx'))->get();
										
				
		$no=0;
		$data = array();
				
		foreach($dttrans as $list){
			$no++;

			$row = array();
			
			$tp ="";
			if($list->sale_type==1){
			    $tp = "Sale";
			}else{
			    $tp = "Retur/BS";
			}
				
			$row[] = $no;
			$row[] = $list->sale_no;
			$row[] = tanggal_indonesia($list->sale_tgl, false);
			$row[] = $tp;
			$row[] = '<div class="text" align="right">'.format_uang($list->sale_total).'</div>';
			$row[] = '<div class="btn-btn">
					<a onclick="deleteItem('.$list->id_piutg.')" class="btn btn-danger btn-sm"><i class="fa fa-trash"></i> delete</a>
					</div>';

            
			$data[] = $row;		

			}
		

		$output = array("data" => $data);
		return response()->json($output);
	}

//simpan detail invoice yg dilunasi
	public function simpan(Request $request)
	{
	    $piutang	= Piutang::find(session('idtrx'));
	    
		$idcust     = $piutang->cust_id;
		
		$idsale  	= $request['kode'];
		$dtsale  	= Penjualan::find($idsale);
		
		if($dtsale->status_retur==1){
			$tlsale = $dtsale->sale_netto - $dtsale->sale_bayar1 ;
		}else{
			$tlsale = $dtsale->sale_netto * -1 ;
		}

		$trxdetail	= New PiutangDetail;
		
		$trxdetail->piutang_id	= $piutang->id_piutang;
		$trxdetail->sale_id	    = $idsale;
		$trxdetail->sale_no	    = $dtsale->sale_no;
		$trxdetail->sale_tgl    = $dtsale->sale_tgl;
		$trxdetail->sale_type	= $dtsale->status_retur;
		$trxdetail->sale_total  = $tlsale;
		$trxdetail->user_id		= Auth::user()->id;
		
		$trxdetail->save();

		$dtsale->sale_lunas = $piutang->id_piutang;
		$dtsale->update();
		
		echo json_encode(array('msg'=>'success'));
	}
			
   public function loadSummary(){
        
		$dtrans	= PiutangDetail::where('piutang_id',session('idtrx'))->get();
		
		$totalrp=0;
										
        foreach($dtrans as $list){
		    $totalrp += $list->sale_total;
        }
        
        $piutang = Piutang::find(session('idtrx'));
        
        $piutang->lunas_total= $totalrp ;
        $piutang->update();
        
        $data = array("totalrp" =>format_uang($totalrp));
                      
        return response()->json($data);
    }			
/*--------------------------------------------------------------------*/

	function tampil($id)
	{
		session(['idinv'=>$id]);
		
		$idinv	    = $id;
		$invoice	= Invoice::where('id_invoice',$id)->get();
		
		foreach($invoice as $list)
		{
			$idsupp	= $list->supp_id;
			$noinv	= $list->inv_no;
			$ppn	= $list->inv_ppn;
			$disc1	= $list->inv_disc;
			$posted	= $list->inv_posted;
		}
		
		$no=1;
		$m_inv		= Invoice::find($id);
		$supplier	= Supplier::find($idsupp);
		$product	= Product::where('supplier',$idsupp)
    								->orderBy('nama_brg','ASC')->get();
    	
    
		return view('invoice_detail.index_history', compact('m_inv','supplier','product','idinv','no'));

	} 
	
	public function NamaRute($id){
	    return Rute::find($id);
	}
	
/*-----------------------------------------------------*/
    public function edit($id)
    {
      $piutang = Piutang::find($id);
      echo json_encode($piutang);
    }
    
 
    public function show($id)
    {
        
    }

	public function batal($id)	
	{
		$piutang = Piutang::find($id);
		
		if ($piutang->lunas_total != 0){
			echo json_encode(array('msg'=>'error'));
		}else{	
			$piutang->sts_batal = 1;
			$piutang->update();

	// insert logs
			$usrnm	= Auth::user()->username;
			
			$userlog = New User_logs;
			$userlog->title		= 'Batal Pelunasan';
			$userlog->content	= 'Pelunasan '.Customer::Customer($piutang->cust_id)->cus_name.' '
								.tanggal_indonesia($piutang->lunas_tgl, false).' berhasil dibatalkan oleh '.$usrnm;
			$userlog->user_id	= Auth::user()->id;
			$userlog->save();			
			
			echo json_encode(array('msg'=>'success'));
		}
	}	
/////////////////////////////////////////////////////////////////////////
	
    public function update(Request $request, $id)
    {
		$tgltrx		= $request['tgltrx'];
		$ket		= $request['ket'];
		$ttl		= $request['ttl'];
		$blt        = $request['bulat'];
			
		$trans	= Piutang::find($id);
			
		//$trans->lunas_tgl	    = $tgltrx;
		$trans->total_bayar		= $ttl;
		$trans->pembulatan      = $blt;
		$trans->lunas_type      = $request['tp'];
		$trans->lunas_notes     = $ket;
		$trans->user_id	    	= Auth::user()->id;
			
		$trans->update();

		echo json_encode(array('msg'=>'success'));
    }


//hapus data detail
   public function destroy($id)
   {
		$dttrx      = PiutangDetail::find($id);
		$msale      = Penjualan::find($dttrx->sale_id);
	    
	    $dttrx->delete(); 
		
		$msale->sale_lunas = 0;
		$msale->update();
		
        echo json_encode(array('msg'=>'success'));		
   }
   
    public function posting($id)
    {

		$piutang = Piutang::find($id);
		
		$ttl = $piutang->lunas_total + $piutang->pembulatan;
		
		if($piutang->total_bayar != $ttl )
		{
			//echo json_encode(array('msg'=>'error'));
			return view('piutang.errmess');
		}else{
			
			$piutang->sts_posted =1;
			$piutang->update();

			return Redirect::route('piutang.index');
		}
    }

/* pembayaran nyicil */

	public function index_cicil(){
		
		$customer = Customer::all();
		
		return view('piutang.index_cicil', compact('customer'));
	
	}

//-------------------------------
	public function getCicil(){

     	$jual = Penjualan::leftjoin('ms_customer', 'ms_sale.cust_id','=','ms_customer.id_cust')
								->where('ms_sale.sale_batal',0)
								->where('ms_sale.sale_lunas', '=',0)
								->where('ms_sale.sale_netto', '>',0)
								->where('ms_sale.status_retur', '=', 1)
								->orderBy('ms_sale.cust_id','ASC')
								->orderby('ms_sale.sale_no','ASC')->get();
		
		$no=1;
		$data = array();
		
		foreach($jual as $list)
		{
			$row = array();
			
			$row[] = $list->sale_no;
			$row[] = tanggal_indonesia($list->sale_tgl, false);
			$row[] = $list->cus_name;
			$row[] = '<div class="text-bold" align="right">'.format_uang($list->sale_netto).'</div>';
			$row[] = '<div class="text-bold" align="right">'.format_uang($list->sale_bayar1).'</div>';
			$row[] = '<div class="text-bold" align="right">'.format_uang($list->sale_bayar2).'</div>';
			$row[] = '<div class="text-bold" align="right">'.format_uang($list->sale_bayar3).'</div>';
            $row[] = '<div class="text-bold" align="right">'.format_uang($list->sale_netto - $list->sale_bayar1 - $list->sale_bayar2 - $list->sale_bayar3).'</div>';
            
            if(Auth::user()->lunas_edit==1){
			    $row[] = '<div class="btn-btn">
					<a onclick="addCicil('.$list->id_sale.')" class="btn btn-success btn-xs"><i class="fa fa-plus"></i> Add </a>
					<a onclick="editCicil('.$list->id_sale.')" class="btn btn-primary btn-xs"><i class="fa fa-pencil"></i> Edit </a>
					</div>';	
				}else{
			    $row[] = '<div class="btn-btn">
					<a onclick="addCicil('.$list->id_sale.')" class="btn btn-success btn-xs"><i class="fa fa-plus"></i> Add </a>
					<a onclick="err_mess()" class="btn btn-default btn-xs"><i class="fa fa-pencil"></i> Edit </a>
					</div>';	
				}
  		    
			$data[] = $row;
		}

		$output = array("data" => $data);
		return response()->json($output);								
			
    }
   
   public function cicil($id)
   {
	   $cicil = Penjualan::find($id);
	   
	   echo json_encode($cicil);
   }
   
   public function simpancicil(Request $request, $id)
   {
	   $cicil = Penjualan::find($id);

        if(!is_null($request['ttl1']))
        {
    	   $cicil->bayar1_tgl	= $request['tgl1'];
    	   $cicil->bayar1_type	= $request['tp1'];
    	   $cicil->sale_bayar1	= $request['ttl1'];
        }
        
        if(!is_null($request['ttl2']))
        {
	       $cicil->bayar2_tgl	= $request['tgl2'];
	       $cicil->bayar2_type  = $request['tp2'];	       
	       $cicil->sale_bayar2  = $request['ttl2'];
        }
        
        if(!is_null($request['ttl3']))
        {
	       $cicil->bayar3_tgl   = $request['tgl3'];
	       $cicil->bayar3_type  = $request['tp3'];	       
	       $cicil->sale_bayar3  = $request['ttl3'];
        }
	   
	   $cicil->update();
	   
	   echo json_encode(array('msg'=>'success'));
	   
   }
	   
   public function updatecicil(Request $request, $id)
   {
	   $cicil = Penjualan::find($id);
	   
    	   $cicil->bayar1_tgl	= $request['tgl1'];
    	   $cicil->bayar1_type	= $request['tp1'];
    	   $cicil->sale_bayar1	= $request['ttl1'];
    	   
	       $cicil->bayar2_tgl	= $request['tgl2'];
	       $cicil->bayar2_type  = $request['tp2'];	       
	       $cicil->sale_bayar2  = $request['ttl2'];

	       $cicil->bayar3_tgl   = $request['tgl3'];
	       $cicil->bayar3_type  = $request['tp3'];	       
	       $cicil->sale_bayar3  = $request['ttl3'];
	       $cicil->update(); 
	       
	   echo json_encode(array('msg'=>'success'));
	   
   }	   
	   
/*------------------------------------------------------------------*/
/* reprint inv */
    public function printform($id)
    {
		$mtrf	= Transfer::find($id);
		$dtrf	= TransferDetail::leftjoin('ms_product', 'dt_transfer.product_id', 'ms_product.id')
									->where('dt_transfer.transfer_id', $id)->get();
					
		$cabang	= Cabang::find($mtrf->to_id);
		$no=1;
		$totalqty=10;
		//return Redirect::route('transferdetail.print');				//cetak po
		return view('transfer_detail.cetak', compact('mtrf', 'dtrf', 'cabang', 'no', 'totalqty'));
    }

/*=================================================================================*/


/* history */
//-------------------------------
	public function history()
	{		
		$customer = Customer::all();
		
		return view('piutang.history', compact('customer'));
	}	

/*------------------------------------------------------*/
    function history_header()
    {

      	$piutang = Piutang::where('ms_piutang.sts_posted',1)
      	                    ->orWhere('ms_piutang.sts_batal', '=',1)
							->get();
		
		$no=1;
		$data = array();
		
		foreach($piutang as $list)
		{
			$row = array();
			
			$tp='';
			switch ($list->lunas_type)
			{
				case 1: $tp="CASH"; break;
				case 2: $tp="Transfer/Giro"; break;
				case 3: $tp="Lain2"; break;
			}
				   
			$row[] = tanggal_indonesia($list->lunas_tgl, false);
			$row[] = Customer::Customer($list->cust_id)->cus_name;
			$row[] = '<div class="text" align="right">'.format_uang($list->total_bayar).'</div>';
			$row[] = '<div class="text-bold" align="right">'.format_uang($list->lunas_total).'</div>';
			$row[] = '<div class="text-bold" align="right">'.format_uang($list->pembulatan).'</div>';
			$row[] = $tp;
			
			if($list->sts_batal==1){
				$row[] = 'BATAL'; }else{
				$row[] = $list->lunas_notes;}			
		
			$row[] = User::NamaUser($list->user_id)->username;
		    $row[] = '<div class="btn-btn">
				        <a onclick="showDetail('.$list->id_piutang.')" class="btn btn-primary btn-sm"><i class="fa fa-list"> detail </i></a>
				    </div>';	

		   $data[] = $row;
		}

		$output = array("data" => $data);
		return response()->json($output);									

    }


//------------------------------history detail

	public function detail($id)
	{

		$dtsale	= Penjualan::where('sale_lunas','=',$id)->get();
		
		$data=array();
		
		foreach($dtsale as $list)
		{
		    
			$row   = array();
		    $row[] = $list->sale_no;
		    $row[] = tanggal_indonesia($list->sale_tgl, false);
            $row[] = '<div class="text" align="right">'.format_uang($list->sale_netto).'</div>';
            $row[] = '<div class="text" align="right">'.format_uang($list->sale_bayar1).'</div>';

            $data[] = $row;
		}
		
		$output = array("data" => $data);
		return response()->json($output);								
	
	} 
    
}
