<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;

use App\Category;
use App\Product;
use App\Company;
use App\Outlet;
use App\Bisinis;
use App\User_logs;
use App\Message;


class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
		$this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        //$awal = date('Y-m-d', mktime(0,0,0, date('m'), 1, date('Y')));
        $akhir = date('Y-m-d');
    	$awal    = date('Y-m-d', strtotime("-15 day", strtotime($akhir)));      
        $tanggal = $awal;
    	$tglnow  = date('Y-m-d');

		$category	= Category::where('is_active',1)
		                            ->get();


		$UserLog	= User_logs::orderBy('id','DESC')
		                        ->limit(500)->get();
					
		$messages   = Message::where('mess_tgl', '=', $tglnow)
                            ->where('read_sts', '=', 0)
                            ->where('mess_user', '=', Auth::user()->username)
                             ->count();

        $valstatus = CompanyController::CekValidStatus();
        
        $valid_info="";
        if($valstatus==false)
        {
            $valid_info = "Masa aktif sudah expired, Hubungi tim support ";
        }

		if(Auth::user()->group=="KASIR"){

		    return view('sales.main', compact('valid_info'));
		    
		}else{
		    
			return view('home.admin', compact('UserLog','messages','valid_info'));
			
		}

    }
}
