<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use DB;
use Datatables;
use App\Customer;
use App\Product;
use App\Formbs;
use App\User;
use App\User_logs;

class FormBSController extends Controller
{
   public function index()
   {
		$customer = Customer::all();
		$product  = Product::orderBy('nama_brg')->get();
		
		return view('formbs.index', compact('customer', 'product')); 
   }

   public function listData( $tgl1, $tgl2)
   {
   
 	 $formbs = Formbs::whereBetween('tgl_terima', [$tgl1, $tgl2])
 	                    ->orderBy('tgl_terima')
 	                    ->get();
 
     $data = array();
     foreach($formbs as $list){
       
       $row = array();
       $row[] = $list->tgl_terima;
       $row[] = Customer::Customer($list->cust_id)->cus_name;
       $row[] = Product::Product($list->brg_id)->nama_brg;
       $row[] = $list->qty;
       $row[] = $list->satuan;
       $row[] = User::NamaUser($list->user_id)->username;
       $row[] = $list->notes;
       if(!is_null($list->tgl_kembali)){
            $row[] = tanggal_indonesia($list->tgl_kembali, false); }else{ $row[]='blm kembali';}
        
        /*
        if(Auth::user()->group=="MANAGER"){
        
            $row[] = '<div class="btn-btn">
        			   <a onclick="editForm('.$list->id_form.')"><i class="fa fa-pencil"></i></a>&nbsp;&nbsp;&nbsp;&nbsp&nbsp;&nbsp;&nbsp;&nbsp
        			   <a onclick="kembaliForm('.$list->id_form.')"><i class="fa fa-retweet"></i></a>&nbsp;&nbsp;&nbsp;&nbsp&nbsp;&nbsp;&nbsp;&nbsp
        			   <a onclick="deleteItem('.$list->id_form.')"><i class="fa fa-times"></i></a>
                       </div>';
        }else{
            if(Auth::user()->bs_kembali==1){
                $row[] ='<div class="btn-btn">
        			   <a onclick="kembaliForm('.$list->id_form.')"><i class="fa fa-retweet">...</i></a>&nbsp;&nbsp;&nbsp;&nbsp&nbsp;&nbsp;&nbsp;&nbsp
                       </div>';
            }else{
                $row[]="";}
        }*/
        
			if(Auth::user()->group=="MANAGER")
            {			
			    $row[]= '<div class="btn-group">
                  <button  class="btn btn-outline-danger btn-xs dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
				  <i class="fa fa-caret-down"></i>
                  </button>
                  <ul class="dropdown-menu dropdown-menu-right" style="border:1px black solid;">
                    <li><a onclick="editForm('.$list->id_form.')"><i class="fa fa-pencil-square-o"></i>Edit Form</a></li>
                    <li><a onclick="kembaliForm('.$list->id_form.')"><i class="fa fa-retweet"></i>Form Kembali</a></li>
                    <li><a onclick="deleteItem('.$list->id_form.')"><i class="fa fa-trash"></i>Delete Form</a></li>
                  </ul>
                </div>';
			
            }else{
			    $row[]= '<div class="btn-group">
                  <button  class="btn btn-outline-danger btn-xs dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
				  <i class="fa fa-caret-down"></i>
                  </button>
                  <ul class="dropdown-menu dropdown-menu-right" style="border:1px black solid;">
                    <li><a onclick="kembaliForm('.$list->id_form.')"><i class="fa fa-retweet"></i>Form Kembali</a></li>
                  </ul>
                </div>';			
			
            }        
        
       $data[] = $row;
     }
		
     $output = array("data" => $data);
     return response()->json($output);
   }

   public function store(Request $request)
   {
  
        //if(is_null($request->tgl1)){ return json_encode(array('msg'=>'error'));}
     
        $formbs = new Formbs;

        $formbs->tgl_terima 	= $request['tgl1'];
	    $formbs->cust_id		= $request['cus'];
	    $formbs->brg_id	    	= $request['brg'];
	    $formbs->qty			= $request['qty'];
	    $formbs->satuan         = $request['stn'];
	    $formbs->notes		    = $request['ket'];
	    $formbs->user_id		= Auth::user()->id;
        $formbs->save();

// insert logs
		$usrnm	= Auth::user()->username;
		$userlog = New User_logs;
		$userlog->title		= 'CREATE Form BS ';
		$userlog->content	= 'Create Form BS '.Customer::Customer($request['cus'])->cus_name.' berhasil by. '.$usrnm;
		$userlog->user_id	= Auth::user()->id;
		$userlog->save();		
	  
	  echo json_encode(array('msg' => 'success'));
   }

   public function show($id)
   {
	   $formbs = Formbs::find($id);
	   echo json_encode($formbs);
   }

   public function edit($id)
   {
     $formbs = Formbs::find($id);
	 $usr	 = User::find($formbs->user_id);
	 
	 echo json_encode(array_merge(json_decode($formbs, true),json_decode($usr, true)));
     //echo json_encode($formbs);
   }

   public function update(Request $request, $id)
   {
        //if(is_null($request->tgl1)){ return json_encode(array('msg'=>'error'));}
       
        $formbs = Formbs::find($id);
	  
	    if($request->kembali==0){
            $formbs->tgl_terima = $request['tgl1'];
    	    $formbs->brg_id		= $request['brg'];
    	    $formbs->qty		= $request['qty'];
    	    $formbs->satuan     = $request['stn'];
    	    $formbs->notes		= $request['ket'];
	  
	    }else{
            $formbs->notes		  = $request['ket'];
	        $formbs->tgl_kembali  = $request['tgl2'];
	    }  
	  
	  $formbs->user_id		= Auth::user()->id;
      $formbs->update();
	  
	  echo json_encode(array('msg' => 'success'));
   }
   
//hapus data detail
   public function destroy($id)
   {
		$dtbs     = Formbs::find($id);
		$cus      = Customer::find($dtbs->cust_id);
		
	    $dtbs->delete(); 
		
// insert logs
		$usrnm	= Auth::user()->username;
		$userlog = New User_logs;
		$userlog->title		= 'DELETE Form BS ';
		$userlog->content	= 'Delete Form BS '.$cus->cus_name.' berhasil by. '.$usrnm;
		$userlog->user_id	= Auth::user()->id;
		$userlog->save();		

        echo json_encode(array('msg'=>'success'));	

   }    

}
