<?php


namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use Redirect;
use DB;
use Carbon;
use Session;

use App\Penjualan;
use App\PenjualanDetail;
use App\Piutang;
use App\Invoice;
use App\Customer;
use App\Supplier;
use PDF;

use App\Exports\ReportExport;

use Illuminate\Support\Facades\Input;
use Excel;


class ExportController extends Controller
{
    public function index_reportsale()
    {
		return view('report.index_reportsale');
    }
    
    public function stock()
    {
        return view('report.index_stock');
    }

    public function about(){
        return view('report.about');
    }
    
    public function import_excel(){
        return view('report.import_excel');
    }
   
    public function stock_excel(){
        return view('report.import_stock');
    }
    
    public function pilihToko($tp)
    {
    
        if(Auth::user()->is_local==1){
            $tk = TokoLocal::where('str_init', Auth::user()->kode_toko)->get();
            $tt=[];
            foreach($tk as $ttt) { $tt[] = $ttt->str_kode; }
            $toko = Toko::whereIn('str_kode', $tt)->get();
        }else{
    
            if($tp==0)
            {
                $toko = DB::table('ms_store')
    	                ->whereIn('str_status', ['1','2'])
    	                ->orderBy('str_name')
    	                ->get();
            }else{
    	        $toko = DB::table('ms_store')
    	                ->where('str_status', $tp)
    	                ->orderBy('str_name')
    	                ->get();
            }
        }
        
        $data = array();
        foreach($toko as $list){
       
            $row = [];
            $row[] = $list->str_kode;
            $row[] = $list->str_name;
            $row[] ="<label class='switch'>
                        <input type='checkbox' name='id[]'' value='".$list->id_store."'>
                        <span class='slider round'></span>
                    </label>";

            $data[] = $row;
        }

        $output = array("data" => $data);
        return response()->json($output);
    }

    public function reportsale(Request $request){
        
        $tgl1   = $request['awal'];
        $tgl2   = $request['akhir'];
        $group  = $request['group'];
        $grp    = $request['grp'];

        $ret = explode("\n", str_replace("\r", "", $group));
        
        $tk=[];
        foreach($request['id'] as $id){
            $toko = Toko::find($id);
            $tk[]=$toko->str_kode;
        }

        $data = $this->getReport($tk, $tgl1, $tgl2, $ret, $grp);  
    
        $no=1;
        //return view('main.reportsale', compact('no', 'data'));
        return view('report.view_sale', compact('no', 'data'));         
            
    }
    
    public static function getReport($tk, $tgl1, $tgl2, $ret, $grp){
        
        /* per category */
        if($grp==1){
            //$data = DB::table('rptsale')
            //    ->select('toko','category', 'sku', 'namabrg')
                
            $data = DB::table('rptsale as A')    
                ->select('A.toko','C.generic_name', 'A.category', 'A.sku', 'A.namabrg')
                ->addSelect(DB::raw('SUM(A.qty) as qty'))
                ->leftjoin('ms_category as B', function($join)
                    {
                        $join->on('A.category','=', 'B.cat_kode');
                    })
                ->leftjoin('ms_generic as C', function($join)
                    {
                        $join->on('B.generic_id', '=', 'C.id_generic');
                    })     
                ->whereBetween('A.tanggal', [$tgl1, $tgl2])
                ->whereIn('A.toko', $tk)
				->whereIn('A.category', $ret)
                ->groupBy('A.toko')
                ->groupBy('C.generic_name')
                ->groupBy('A.sku')
                ->groupBy('A.category')
                ->groupBy('A.namabrg')
                ->orderBy('A.toko','ASC')
                ->orderBy('C.generic_name', 'ASC')
                ->orderBy('A.category', 'ASC')
                ->orderBy('A.sku','ASC')
                ->get();
        }
        
        /* per sku */
        if($grp==2){
            $data = DB::table('rptsale as A')    
                ->select('A.toko','C.generic_name', 'A.category', 'A.sku', 'A.namabrg')
                ->addSelect(DB::raw('SUM(A.qty) as qty'))
                ->leftjoin('ms_category as B', function($join)
                    {
                        $join->on('A.category','=', 'B.cat_kode');
                    })
                ->leftjoin('ms_generic as C', function($join)
                    {
                        $join->on('B.generic_id', '=', 'C.id_generic');
                    })     
                ->whereBetween('A.tanggal', [$tgl1, $tgl2])
                ->whereIn('A.toko', $tk)
				->whereIn('A.sku', $ret)
                ->groupBy('A.toko')
                ->groupBy('C.generic_name')
                ->groupBy('A.sku')
                ->groupBy('A.category')
                ->groupBy('A.namabrg')
                ->orderBy('A.toko','ASC')
                ->orderBy('C.generic_name','ASC')
                ->orderBy('A.category', 'ASC')
                ->orderBy('A.sku','ASC')
                ->get(); 
        }
        
        /* per generic*/
        if($grp==3){
            
            $gen = Generic::whereIn('generic_kode', $ret)->get();
            $cc = [];
            foreach($gen as $gg){ $cc[] = $gg->id_generic; }
            $aa = Category::whereIn('generic_id', $cc)->get();
            $cat=[];
            foreach( $aa as $bb) { $cat[] = $bb->cat_kode; }
            
            $data = DB::table('rptsale as A')
                ->select('A.toko','C.generic_name', 'A.category', 'A.sku', 'A.namabrg')
                ->addSelect(DB::raw('SUM(A.qty) as qty'))
                ->leftjoin('ms_category as B', function($join)
                    {
                        $join->on('A.category','=', 'B.cat_kode');
                    })
                ->leftjoin('ms_generic as C', function($join)
                    {
                        $join->on('B.generic_id', '=', 'C.id_generic');
                    })
                ->whereBetween('tanggal', [$tgl1, $tgl2])
                ->whereIn('A.toko', $tk)
				->whereIn('A.category', $cat)
                ->groupBy('A.toko')
                ->groupBy('A.sku')
                ->groupBy('A.category')
                ->groupBy('C.generic_name')
                ->groupBy('A.namabrg')
                ->orderBy('A.toko','ASC')
                ->orderBy('C.generic_name','ASC')
                ->orderBy('A.category', 'ASC')
                ->orderBy('A.sku','ASC')
                ->get();
     
                
        }        
        
        return $data;
    }
    
    
	public function export_excel(Request $request)
	{
	    /* initial format excel */
	    ob_end_clean(); 
		ob_start(); 
		
		$file_xls = 'reportsale.xls';
		return Excel::download(new ReportExport($request->id, $request->awal, $request->akhir, $request->grp, $request->group, $request->tipetoko), $file_xls);
	}

    public function import_from_excel() {
        

        Excel::import(new ReportsaleImport, request()->file('file'));
		
		Session::flash('sukses','Data Berhasil Diimport!');
		return back();
    }

    public function stock_from_excel(Request $request) {
        
		$this->validate($request, [
			'file' => 'required|mimes:csv,xls,xlsx'
		]);
 
		// menangkap file excel
		$file = $request->file('file');
		$path = $request->file('file')->getRealPath();
		$name = $request->file('file')->getClientOriginalName();

        $kdtoko = substr($name,6,3);
        
        /* reset stock*/
        DB::table('reportstock')
                ->where('toko','=', $kdtoko)->delete();
        
        Excel::import(new StockImport, request()->file('file'));

		Session::flash('sukses','Data Stock '.$kdtoko.' Berhasil Diimport ! ');
		return back();
    }

/* report stock */
    public function reportstock(Request $request){
        
        $group  = $request['group'];
        $grp    = $request['grp'];
        $tp     = $request['tipetoko'];

        $ret = explode("\n", str_replace("\r", "", $group));
        
        $data = $this->getStock( $ret, $grp, $tp);  
    
        $no=1;
        
        //return view('main.reportstock', compact('no', 'data'));         
        if($tp==2){
            return view('report.view_stock', compact('no', 'data'));         
        }else{
            return view('report.view_stockspm', compact('no', 'data'));
        }
    }
    
    public static function getStock($ret, $grp, $tp){
        
        /* per category */
        if($grp==1){

            $data = DB::table('reportstock as A')    
                //->select('C.generic_name', 'A.*', 'D.sku_name')
                ->select('A.ct','A.sku','D.sku_name','A._101','A._003','A._102','A._005','A._007','A._109','A._006','A._105','A._108','A._008','A._110','A._010','A._111','A._011','A._301','A._401','A._601','A._602','A._208','A._201')
                ->leftjoin('ms_category as B', function($join)
                    {
                        $join->on('A.ct','=', 'B.cat_kode');
                    })
                ->leftjoin('ms_generic as C', function($join)
                    {
                        $join->on('B.generic_id', '=', 'C.id_generic');
                    })     
                ->leftjoin('ms_product as D', function($join)
                    {
                        $join->on('A.sku', '=', 'D.sku_kode');
                    })                      
				->whereIn('A.ct', $ret)
                //->orderBy('C.generic_name', 'ASC')
                ->orderBy('A.ct', 'ASC')
                ->orderBy('A.sku','ASC')
                ->get();
        }
        
        /* per sku */
        if($grp==2){
            $data = DB::table('reportstock as A')    
                //->select('C.generic_name', 'A.*', 'D.sku_name')
                ->select('A.ct','A.sku','D.sku_name','A._101','A._003','A._102','A._005','A._007','A._109','A._006','A._105','A._108','A._008','A._110','A._010','A._111','A._011','A._301','A._401','A._601','A._602','A._208','A._201')
                ->leftjoin('ms_category as B', function($join)
                    {
                        $join->on('A.ct','=', 'B.cat_kode');
                    })
                ->leftjoin('ms_generic as C', function($join)
                    {
                        $join->on('B.generic_id', '=', 'C.id_generic');
                    })     
                ->leftjoin('ms_product as D', function($join)
                    {
                        $join->on('A.sku', '=', 'D.sku_kode');
                    })                       
				->whereIn('A.sku', $ret)
                //->orderBy('C.generic_name','ASC')
                ->orderBy('A.ct', 'ASC')
                ->orderBy('A.sku','ASC')
                ->get(); 
        }
        
        /* per generic*/
        if($grp==3){
            
            $gen = Generic::whereIn('generic_kode', $ret)->get();
            $cc = [];
            foreach($gen as $gg){ $cc[] = $gg->id_generic; }
            $aa = Category::whereIn('generic_id', $cc)->get();
            $cat=[];
            foreach( $aa as $bb) { $cat[] = $bb->cat_kode; }
            
            $data = DB::table('reportstock as A')
                //->select('C.generic_name', 'A.*', 'D.sku_name')
                ->select('A.ct','A.sku','D.sku_name','A._101','A._003','A._102','A._005','A._007','A._109','A._006','A._105','A._108','A._008','A._110','A._010','A._111','A._011','A._401','A._301','A._601','A._602','A._208','A._201')
                ->leftjoin('ms_category as B', function($join)
                    {
                        $join->on('A.ct','=', 'B.cat_kode');
                    })
                ->leftjoin('ms_generic as C', function($join)
                    {
                        $join->on('B.generic_id', '=', 'C.id_generic');
                    })     
                ->leftjoin('ms_product as D', function($join)
                    {
                        $join->on('A.sku', '=', 'D.sku_kode');
                    })                       
				->whereIn('A.ct', $cat)
                //->orderBy('C.generic_name','ASC')
                ->orderBy('A.ct', 'ASC')
                ->orderBy('A.sku','ASC')
                ->get();
                
        }        
        
        return $data;
    }

    public function stock_toexcel(Request $request){
	    /* initial format excel */
	    ob_end_clean(); 
		ob_start(); 
		
		$file_xls = 'reportstock.xls';
		return Excel::download(new StockExport($request->grp, $request->group, $request->tipetoko), $file_xls);
        
    }
    
    public function infoStock(){
        $inf = InfoStock::orderBy('namatoko','ASC')->get();
        $no=0;
        $data=[];
        
        foreach($inf as $ii){
            
            $no++;
            $row=[];
            $row[] = $no;
            //$row[] = $ii->toko;
            $row[] = $ii->namatoko;
            $row[] = date_format($ii->updated_at, 'Y-m-d H:i:s');;
            $data[] = $row;
        }
        
        $output=["data"=>$data];
        return response()->json($output);
    }
    
    public function masterTemplate(){
        return view('report.index_template');
    }

    public function getTemplate(){
        $tmp = MasterTemplate::leftjoin('ms_generic', 'ms_generic.id_generic','=','ms_template.generic_id')
                                ->where('ms_template.user_id', Auth::user()->id)
                                ->orderBy('ms_template.generic_id', 'ASC')
                                ->get();
                                
        $data=[];                        
        foreach($tmp as $list){
            $row=[];
            $row[]= $list->generic_kode;
            $row[]= $list->generic_name;
            $row[]= '<a onclick="deleteTemp("'.$list->id.')" class="btn btn-flat btn-danger"><i class="fa fa-trash"></i>Delete</a>';
            
            $data[]=$row;
            
        }    
        
        $output=["data" => $data];
        return response()->json($output);
                            
    }
    
    public function detailstock($id, $tp){
        
        $prd = Product::find($id);
        $stk = Stock::find($prd->sku_kode);
        
        $data=[];
        
        if($tp==1){
            $row=[];
            $row[]= "SKU";
            $row[]= $prd->sku_kode." - ".$prd->sku_name;
            $data[]=$row;
            
            $row=[];
            $row[]= "Pasaraya JM SPM";
            $row[]= format_uang($stk->_003);
            $data[]=$row;
            
            $row=[];
            $row[]= "Psr. Bandung SPM";
            $row[]= format_uang($stk->_005);
            $data[]=$row;
            
            $row=[];
            $row[]= "JM Kenten SPM";
            $row[]= format_uang($stk->_006);
            $data[]=$row;
            
            $row=[];
            $row[]= "JM Sukarami SPM";
            $row[]= format_uang($stk->_008);
            $data[]=$row;

            $row=[];
            $row[]= "JM Plaju SPM";
            $row[]= format_uang($stk->_010);
            $data[]=$row;
            
            $row=[];
            $row[]= "JM Lemabang SPM";
            $row[]= format_uang($stk->_011);
            $data[]=$row;

            $row=[];
            $row[]= "JM Linggau SPM";
            $row[]= format_uang($stk->_301);
            $data[]=$row;

         }else{

            $row=[];
            $row[]= "SKU";
            $row[]= $prd->sku_kode." - ".$prd->sku_name;
            $data[]=$row;
            
            $row=[];
            $row[]= "Pasaraya JM DST";
            $row[]= format_uang($stk->_101);
            $data[]=$row;
            
            $row=[];
            $row[]= "Pasaraya JM SPM";
            $row[]= format_uang($stk->_003);
            $data[]=$row;
            
            $row=[];
            $row[]= "Psr. Bandung DST";
            $row[]= format_uang($stk->_102);
            $data[]=$row;
            
            $row=[];
            $row[]= "Psr. Bandung SPM";
            $row[]= format_uang($stk->_005);
            $data[]=$row;
            
            $row=[];
            $row[]= "Gaya Baru";
            $row[]= format_uang($stk->_007);
            $data[]=$row;
            
            $row=[];
            $row[]= "JM Kenten DST";
            $row[]= format_uang($stk->_109);
            $data[]=$row;
            
            $row=[];
            $row[]= "JM Kenten SPM";
            $row[]= format_uang($stk->_006);
            $data[]=$row;
            
            $row=[];
            $row[]= "Grand JM";
            $row[]= format_uang($stk->_105);
            $data[]=$row;        
            
            $row=[];
            $row[]= "JM Sukarami DST";
            $row[]= format_uang($stk->_108);
            $data[]=$row;
            
            $row=[];
            $row[]= "JM Sukarami SPM";
            $row[]= format_uang($stk->_008);
            $data[]=$row;

            $row=[];
            $row[]= "JM Plaju DST";
            $row[]= format_uang($stk->_110);
            $data[]=$row;
            
            $row=[];
            $row[]= "JM Plaju SPM";
            $row[]= format_uang($stk->_010);
            $data[]=$row;
            
            $row=[];
            $row[]= "JM Lemabang DST";
            $row[]= format_uang($stk->_111);
            $data[]=$row;
            
            $row=[];
            $row[]= "JM Lemabang SPM";
            $row[]= format_uang($stk->_011);
            $data[]=$row;

            $row=[];
            $row[]= "JM Linggau DST";
            $row[]= format_uang($stk->_401);
            $data[]=$row;
            
            $row=[];
            $row[]= "JM Linggau SPM";
            $row[]= format_uang($stk->_301);
            $data[]=$row;

            $row=[];
            $row[]= "CPM";
            $row[]= format_uang($stk->_601);
            $data[]=$row;
            
            $row=[];
            $row[]= "CPL";
            $row[]= format_uang($stk->_602);
            $data[]=$row;

        }  
    
        $output = ["data" => $data];
        return response()->json($output);
    }

/*rafaksi */
	public function index_rafaksi(){
		return view('report.index_rafaksi');
	}
    
    function hdr_rafaksi()
    {
        $tglnow=date('Y-m-d');
        
     	$hdr = MSRafaksi::leftjoin('ms_supp', 'ms_rafaksi.sup_kode','=','ms_supp.sup_id')
     	                        ->where('ms_rafaksi.is_posted','=',1)
                                ->get();
		$data = [];
		foreach($hdr as $list)
		{
		   $row = [];
			   
		   $row[] = $list->raf_no;
		   $row[] = $list->sup_kode." - ".$list->sup_nama;
		   $row[] = $list->start;
		   $row[] = $list->end;
		   $row[] = $list->raf_toko;
   		   $row[] = '<div class="btn-group">
				   <a href="/report/report/'.$list->id.'/displayrafaksi" class="btn btn-outline-success btn-xs" style="margin-top:-8px;margin-bottom:-5px;"><i class="fa fa-eye"></i></a>
				   <a href="/report/report/'.$list->id.'/reportrafaksi" class="btn btn-outline-primary btn-xs" style="margin-top:-8px;margin-bottom:-5px;"><i class="fa fa-print"></i></a>
				   </div>';	
		   $data[] = $row;
		}

		$output = array("data" => $data);
		return response()->json($output);								
			
    }		

	function displayRafaksi($id)
	{
		
		$idraf	= $id;
		$m_raf	= MSRafaksi::find($id);
		$sup	= Supplier::where('sup_id',$m_raf->sup_kode)->first();
		
	    return view('report.index_detail', compact('m_raf','sup'));
	} 
    	
    public function detailRafaksi($id){
        
        $dt = DTRafaksi::where('raf_id', $id)
                            ->get();
                            
        $data=[];
        foreach($dt as $list){
            $row=[];
            $row[]= $list->sku_kode;
            $row[]= Product::cekProduct($list->sku_kode)->sku_name;
            $row[]= format_uang($list->hg_normal);
            $row[]= format_uang($list->hg_rafaksi);
            $row[]= $list->qty;
            $row[]= $list->max;

            $data[]=$row;
        }
        
        $output=["data"=>$data];
        return response()->json($output);
    }	
	
    public function viewMemo($id){
        $no=1;
        $raf = MSRafaksi::find($id);
        $tk  = explode("\n", str_replace("\r", "", $raf->raf_toko));

        $tt=[];
        foreach($tk as $key=>$value) { $tt[]=$value; }
        $toko = Toko::whereIn('str_kode', $tt)->get();
        
        
        $det  = DTRafaksi::where('raf_id',$id)->get();
        $sup  = Supplier::where('sup_id', $raf->sup_kode)->first();
        
        return view('report.printmemo', compact('raf','toko','det','sup','no'));
    }	
	
	public function reportRafaksi($id){
		
		$raf = MSRafaksi::find($id);
		$det = DTRafaksi::where('raf_id', $id)->get();
		$sup = Supplier::where('sup_id', $raf->sup_kode)->first();
		
		$tk  = explode("\n", str_replace("\r", "", $raf->raf_toko));

		$toko=[];
        foreach($tk as $key=>$value) { $toko[]=$value; }		
		$tgl1=$raf->start;
		$tgl2=$raf->end;
		
		$tt=Toko::whereIn('str_kode', $toko)->orderBy('str_kode','ASC')->get();
		foreach($tt as $kk) {$idxtoko = $kk->str_kode; break; }
		
		$sku =[];
		foreach($det as $dd) { $sku[]= $dd->sku_kode; }
		
		$dt = DB::table('rptsale as A')
                ->select('A.toko','A.sku', 'B.sku_name', 'A.faktor1')
                ->addSelect(DB::raw('SUM(A.qty) as qty'))
				->addSelect(DB::raw('SUM(A.disc_rp) as disc_rp'))
				->addSelect(DB::raw('SUM(A.qty * A.faktor1 - A.disc_rp) as ttl'))
                ->leftjoin('ms_product as B', function($join)
                    {
                        $join->on('A.sku', '=', 'B.sku_kode');
                    }) 				
                ->whereBetween('tanggal', [$tgl1, $tgl2])
				->where('A.disc_rp','>',0)
                ->whereIn('A.toko', $toko)
				->whereIn('A.sku', $sku)
                ->groupBy('A.toko')
                ->groupBy('A.sku')
                ->groupBy('B.sku_name')
				->groupBy('A.faktor1')
                ->orderBy('A.toko','ASC')
                ->orderBy('A.sku','ASC')
                ->get();

		//	$output=["data"=>$dt];
		//	return response()->json($dt);
			

		$data=[];
		$tk='003';
		$tlq = 0;
		$tlv = 0;
		$gtl = 0;
		$totalv=0;
		$tldisc= 0;
		$gtldisc=0;
		
		foreach($dt as $list){
			$row=[];		
			
			if($list->toko != $idxtoko ){ 	

				$row[]='';
				$row[]='';
				$row[]='--- Total ---';
				$row[]=number_format($tlq);
				$row[]="";
				$row[]=number_format($tldisc);				
				$row[]=number_format($tlv);
				$data[]=$row;
				
				$idxtoko=$list->toko;
				$tlq=0;
				$tlv=0;
				$tldisc=0;

			}
				
			$row=[];
			$row[]=$list->toko;
			$row[]=$list->sku;
			$row[]=$list->sku_name;
			$row[]=number_format($list->qty);
			$row[]=number_format($list->faktor1);
			$row[]=number_format($list->disc_rp);
			$row[]=number_format($list->ttl);
			
			$tlq = $tlq + $list->qty;
			$tlv = $tlv + $list->ttl;
			$tldisc = $tldisc + $list->disc_rp;
			$gtl = $gtl + $list->qty;
			$gtldisc= $gtldisc + $list->disc_rp;
			$totalv = $totalv + $list->ttl;	
			
			$data[]=$row;
		}

		$row=[];
		$row[]='';
		$row[]='';
		$row[]='--- Total ---';
		$row[]=number_format($tlq);	
		$row[]="";		
		$row[]=number_format($tldisc);
		$row[]=number_format($tlv);
		
		$data[]=$row;
		
		$row=[];
		$row[]='';
		$row[]='';
		$row[]='--- GRAND TOTAL ---';
		$row[]=number_format($gtl);	
		$row[]="";
		$row[]=number_format($gtldisc);
		$row[]=number_format($totalv);
		$data[]=$row;
		
		return view('report.view_rafaksi', compact('data','raf','sup'));

	}	
	
	public function tesreport(){
		
		$tgl1='2021-01-01';
		$tgl2='2021-01-15';
		$tk=['003','005','006','008','010','011'];
		$sku =['0000023','0000034','0000041','0000216'];
		
		$dt = DB::table('rptsale as A')
                ->select('A.toko','A.sku', 'A.namabrg')
                ->addSelect(DB::raw('SUM(A.qty) as qty'))
				->addSelect(DB::raw('SUM(A.qty * A.faktor1 - A.disc_rp) as ttl'))
                ->whereBetween('tanggal', [$tgl1, $tgl2])
                ->whereIn('A.toko', $tk)
				->whereIn('A.sku', $sku)
                ->groupBy('A.toko')
                ->groupBy('A.sku')
                ->groupBy('A.namabrg')
                ->orderBy('A.toko','ASC')
                ->orderBy('A.sku','ASC')
                ->get();

		$data=[];
		$tk='003';
		$tlq = 0;
		$tlv = 0;
		$gtl = 0;
		$totalv=0;
		foreach($dt as $list){
			$row=[];		
			
			if($list->toko != $tk){ 				
				$row[]='';
				$row[]='';
				$row[]='--- Total ---';
				$row[]=number_format($tlq);
				$row[]=number_format($tlv);
				$tk=$list->toko;
				$tlq=0;
				$tlv=0;
			}else{
				
				$row[]=$list->toko;
				$row[]=$list->sku;
				$row[]=$list->namabrg;
				$row[]=number_format($list->qty);
				$row[]=number_format($list->ttl);
				
				$tlq = $tlq + $list->qty;
				$tlv = $tlv + $list->ttl;
				$gtl = $gtl + $list->qty;
				$totalv = $totalv + $list->ttl;
				
			}
			
			$data[]=$row;
		}
		$row=[];
		$no++;
		$no_	= sprintf("%03s", $no);		
		
		$row[]='';
		$row[]='';
		$row[]='--- Total ---';
		$row[]=number_format($tlq);		
		$row[]=number_format($tlv);
		$data[]=$row;
		
		$row=[];
		$no++;
		$no_	= sprintf("%03s", $no);		
		
		$row[]='';
		$row[]='';
		$row[]='--- Grand Total ---';
		$row[]=format_uang($gtl);		
		$row[]=format_uang($totalv);
		$data[]=$row;
		
		return view('report.view_rafaksi', compact('data'));

	}	
	
	public function index_rekapdatastock(){
	    
	     $inf = InfoStock::orderBy('namatoko','ASC')->get();
	     $no=1;
	     return view('report.index_rekapstock', compact('inf','no'));
	}
	
	public function rekapStock(){
	    
        $data = $this->get_RekapDataStock();  
        $no=1;
        
        return view('report.view_rekapstock', compact('no', 'data'));     	    
	}
	
	public function get_rekapDataStock(){
	    $tbltoko = StockToko::where('is_active',1)
	                            ->get();
	                            
	   $data=[];
	   foreach($tbltoko as $tk){
	        
	        $tt="_".$tk->str_kode;
	        $prc="C.price_0".$tk->str_zone;
	       
	        $stk = DB::table('reportstock as A')    
	            ->select(DB::raw('"'.$tk->str_init.'" as toko'))
                ->addSelect('B.grouping')
                ->addSelect(DB::raw('SUM(A.'.$tt.') as qty'))
                ->addSelect(DB::raw('SUM(A.'.$tt.'*'.$prc.') as total'))
                ->leftjoin('ms_divisi as B', function($join)
                    {
                        $join->on('A.dv','=', 'B.div_kode');
                    })
                ->leftjoin('dt_price as C', function($join)
                    {
                        $join->on('A.sku', '=', 'C.price_sku');
                    })
                ->groupBy('B.grouping')
                ->get();
            
            $tlv=0;
            $tlq=0;
            
            foreach($stk as $dt){
                $row=[];
                $row[]=$dt->toko;
                $row[]=$dt->grouping;
                $row[]=$dt->qty;
                $row[]=$dt->total;
                $data[]=$row;               
                
                $tlv = $tlv + $dt->total;
                $tlq = $tlq + $dt->qty;
           }
	       $row=[];
	       $row[]="";
	       $row[]="TOTAL";
	       $row[]=$tlq;
	       $row[]=$tlv;
	       $data[]=$row;
	       
	    }
	   
	    return $data;

	}
	
/* report sale untuk MD ada value */

    public function report_salemd(){
        //return view('report.index_reportsale');
        return view('report.index_rptsalemd');
    }

    public function reportsale_MD(Request $request){
        
        $tgl1   = $request['awal'];
        $tgl2   = $request['akhir'];
        $group  = $request['group'];
        $grp    = $request['grp'];
        $sss    = $request['supl'];

        $ret = explode("\n", str_replace("\r", "", $group));
        $sup = explode("\n", str_replace("\r", "", $sss));
        
        $supl=[];
        foreach($sup as $sp){ $supl[]=$sp; }
        
        $persupp=true;
        if($sss==""){ $persupp=false;}
        
        $tk=[];
        foreach($request['id'] as $id){
            $toko = Toko::find($id);
            $tk[]=$toko->str_kode;
        }


        if($persupp==false){
            $data = $this->getReportMD($tk, $tgl1, $tgl2, $ret, $grp);  
        }else{
            $data = $this->getReportMD2($tk, $tgl1, $tgl2, $ret, $grp, $supl);  
        }
        
        $tlqty=0;
        $tlval=0;
        foreach($data as $dt) { $tlqty += $dt->qty; $tlval += $dt->nilai; }
    
        $no=1;
        $nourut=1;
        $periode="Peiode: ".$tgl1." - ".$tgl2;
    
        return view('report.view_salemd', compact('no', 'data', 'periode', 'tlqty', 'tlval','nourut'));       
            
    }
    
    public function reportsaleMD(Request $request){
        
        $tgl1   = $request['awal'];
        $tgl2   = $request['akhir'];
        $group  = $request['group'];
        $grp    = $request['grp'];

        $ret = explode("\n", str_replace("\r", "", $group));
        
        $tk=[];
        foreach($request['id'] as $id){
            $toko = Toko::find($id);
            $tk[]=$toko->str_kode;
        }

        $data = $this->getReportMD($tk, $tgl1, $tgl2, $ret, $grp);  
        $tlqty=0;
        $tlval=0;
        foreach($data as $dt) { $tlqty += $dt->qty; $tlval += $dt->nilai; }
    
        $no=1;
        $nourut=1;
        $periode="Peiode: ".$tgl1." - ".$tgl2;
    
        return view('report.view_salemd', compact('no', 'data', 'periode', 'tlqty', 'tlval','nourut'));       
            
    }    
    
    public static function getReportMD($tk, $tgl1, $tgl2, $ret, $grp){
        
        /* per category */
        if($grp==1){

            $data = DB::table('rptsale as A')    
                ->select('A.toko','C.generic_name', 'A.category', 'A.sku', 'A.namabrg')
                ->addSelect(DB::raw('SUM(A.qty) as qty'))
                ->addSelect(DB::raw('SUM(A.qty * A.faktor1 - A.disc_rp) as nilai'))
                ->leftjoin('ms_category as B', function($join)
                    {
                        $join->on('A.category','=', 'B.cat_kode');
                    })
                ->leftjoin('ms_generic as C', function($join)
                    {
                        $join->on('B.generic_id', '=', 'C.id_generic');
                    })     
                ->whereBetween('A.tanggal', [$tgl1, $tgl2])
                ->whereIn('A.toko', $tk)
				->whereIn('A.category', $ret)
                ->groupBy('A.toko')
                ->groupBy('C.generic_name')
                ->groupBy('A.sku')
                ->groupBy('A.category')
                ->groupBy('A.namabrg')
                ->orderBy('A.toko','ASC')
                ->orderBy('C.generic_name', 'ASC')
                ->orderBy('A.category', 'ASC')
                ->orderBy('A.sku','ASC')
                ->get();
        }
        
        /* per sku */
        if($grp==2){
            $data = DB::table('rptsale as A')    
                ->select('A.toko','C.generic_name', 'A.category', 'A.sku', 'A.namabrg')
                ->addSelect(DB::raw('SUM(A.qty) as qty'))
                ->addSelect(DB::raw('SUM(A.qty * A.faktor1 - A.disc_rp) as nilai'))
                ->leftjoin('ms_category as B', function($join)
                    {
                        $join->on('A.category','=', 'B.cat_kode');
                    })
                ->leftjoin('ms_generic as C', function($join)
                    {
                        $join->on('B.generic_id', '=', 'C.id_generic');
                    })     
                ->whereBetween('A.tanggal', [$tgl1, $tgl2])
                ->whereIn('A.toko', $tk)
				->whereIn('A.sku', $ret)
                ->groupBy('A.toko')
                ->groupBy('C.generic_name')
                ->groupBy('A.sku')
                ->groupBy('A.category')
                ->groupBy('A.namabrg')
                ->orderBy('A.toko','ASC')
                ->orderBy('C.generic_name','ASC')
                ->orderBy('A.category', 'ASC')
                ->orderBy('A.sku','ASC')
                ->get(); 
        }
        
        /* per generic*/
        if($grp==3){
            
            $gen = Generic::whereIn('generic_kode', $ret)->get();
            $cc = [];
            foreach($gen as $gg){ $cc[] = $gg->id_generic; }
            $aa = Category::whereIn('generic_id', $cc)->get();
            $cat=[];
            foreach( $aa as $bb) { $cat[] = $bb->cat_kode; }
            
            $data = DB::table('rptsale as A')
                ->select('A.toko','C.generic_name', 'A.category', 'A.sku', 'A.namabrg')
                ->addSelect(DB::raw('SUM(A.qty) as qty'))
                ->addSelect(DB::raw('SUM(A.qty * A.faktor1 - A.disc_rp) as nilai'))
                ->leftjoin('ms_category as B', function($join)
                    {
                        $join->on('A.category','=', 'B.cat_kode');
                    })
                ->leftjoin('ms_generic as C', function($join)
                    {
                        $join->on('B.generic_id', '=', 'C.id_generic');
                    })
                ->whereBetween('tanggal', [$tgl1, $tgl2])
                ->whereIn('A.toko', $tk)
				->whereIn('A.category', $cat)
                ->groupBy('A.toko')
                ->groupBy('A.sku')
                ->groupBy('A.category')
                ->groupBy('C.generic_name')
                ->groupBy('A.namabrg')
                ->orderBy('A.toko','ASC')
                ->orderBy('C.generic_name','ASC')
                ->orderBy('A.category', 'ASC')
                ->orderBy('A.sku','ASC')
                ->get();

        }        
        
        return $data;
    }
    
    /* report sale bisa per supplier */
    public static function getReportMD2($tk, $tgl1, $tgl2, $ret, $grp, $supl){
        
        /* filter sku per sup */
        $dtsku = DB::table('pricelist as A')
                    ->select('A.sup_kode','A.list_sku')
                    ->whereIn('A.sup_kode', $supl)
                    ->get();

        $sku=[];
        foreach($dtsku as $ss){ $sku[]= $ss->list_sku; }

        /* per category */
        if($grp==1){

            $data = DB::table('rptsale as A')    
                ->select('A.toko','C.generic_name', 'A.category', 'A.sku', 'A.namabrg')
                ->addSelect(DB::raw('SUM(A.qty) as qty'))
                ->addSelect(DB::raw('SUM(A.qty * A.faktor1 - A.disc_rp) as nilai'))
                ->leftjoin('ms_category as B', function($join)
                    {
                        $join->on('A.category','=', 'B.cat_kode');
                    })
                ->leftjoin('ms_generic as C', function($join)
                    {
                        $join->on('B.generic_id', '=', 'C.id_generic');
                    })     
                ->whereBetween('A.tanggal', [$tgl1, $tgl2])
                ->whereIn('A.toko', $tk)
				->whereIn('A.category', $ret)
				->whereIn('A.sku', $sku)
                ->groupBy('A.toko')
                ->groupBy('C.generic_name')
                ->groupBy('A.sku')
                ->groupBy('A.category')
                ->groupBy('A.namabrg')
                ->orderBy('A.toko','ASC')
                ->orderBy('C.generic_name', 'ASC')
                ->orderBy('A.category', 'ASC')
                ->orderBy('A.sku','ASC')
                ->get();
        }
        
        /* per sku */
        if($grp==2){
            $data = DB::table('rptsale as A')    
                ->select('A.toko','C.generic_name', 'A.category', 'A.sku', 'A.namabrg')
                ->addSelect(DB::raw('SUM(A.qty) as qty'))
                ->addSelect(DB::raw('SUM(A.qty * A.faktor1 - A.disc_rp) as nilai'))
                ->leftjoin('ms_category as B', function($join)
                    {
                        $join->on('A.category','=', 'B.cat_kode');
                    })
                ->leftjoin('ms_generic as C', function($join)
                    {
                        $join->on('B.generic_id', '=', 'C.id_generic');
                    })     
                ->whereBetween('A.tanggal', [$tgl1, $tgl2])
                ->whereIn('A.toko', $tk)
				->whereIn('A.sku', $ret)
                ->groupBy('A.toko')
                ->groupBy('C.generic_name')
                ->groupBy('A.sku')
                ->groupBy('A.category')
                ->groupBy('A.namabrg')
                ->orderBy('A.toko','ASC')
                ->orderBy('C.generic_name','ASC')
                ->orderBy('A.category', 'ASC')
                ->orderBy('A.sku','ASC')
                ->get(); 
        }
        
        /* per generic*/
        if($grp==3){
            
            $gen = Generic::whereIn('generic_kode', $ret)->get();
            $cc = [];
            foreach($gen as $gg){ $cc[] = $gg->id_generic; }
            $aa = Category::whereIn('generic_id', $cc)->get();
            $cat=[];
            foreach( $aa as $bb) { $cat[] = $bb->cat_kode; }
            
            $data = DB::table('rptsale as A')
                ->select('A.toko','C.generic_name', 'A.category', 'A.sku', 'A.namabrg')
                ->addSelect(DB::raw('SUM(A.qty) as qty'))
                ->addSelect(DB::raw('SUM(A.qty * A.faktor1 - A.disc_rp) as nilai'))
                ->leftjoin('ms_category as B', function($join)
                    {
                        $join->on('A.category','=', 'B.cat_kode');
                    })
                ->leftjoin('ms_generic as C', function($join)
                    {
                        $join->on('B.generic_id', '=', 'C.id_generic');
                    })
                ->whereBetween('tanggal', [$tgl1, $tgl2])
                ->whereIn('A.toko', $tk)
				->whereIn('A.category', $cat)
				->whereIn('A.sku', $sku)
                ->groupBy('A.toko')
                ->groupBy('A.sku')
                ->groupBy('A.category')
                ->groupBy('C.generic_name')
                ->groupBy('A.namabrg')
                ->orderBy('A.toko','ASC')
                ->orderBy('C.generic_name','ASC')
                ->orderBy('A.category', 'ASC')
                ->orderBy('A.sku','ASC')
                ->get();

        }        
        
        return $data;
    }
        
    
    
	public function export_excel_MD(Request $request)
	{
	    
	    /* initial format excel */
	    ob_end_clean(); 
		ob_start(); 
		
		$file_xls = 'report_sale.xls';
	    return Excel::download(new ReportMDExport($request->id, $request->awal, $request->akhir, $request->grp, $request->group, $request->tipetoko, $request->supl), $file_xls);
	}	
	
    public function index_supp(){
        return view('report.index_rptsalemd');
    }	
	
	
	public function listsupplier()
    {

		$sup = Supplier::where('sup_status', '=', '0')
		                ->orderBy('sup_nama')->get();

       	$data = [];
		foreach($sup as $list){
			$row = array();

			$row[] = $list->sup_id ;
            $row[] = $list->sup_nama ;
            $row[] = $list->sup_kota ;
      		$row[] = '<div class="btn-btn">
						<a onclick="selectSupl('.$list->id_supp.')" class="btn btn-flat btn-xs btn-outline-success" style="margin-top:-5px;margin-bottom:-5px;"><i class="fa fa-check"></i></a>
					</div>';
			$data[] = $row;
		}

        $output = array("data" => $data);
        return response()->json($output);
    }   
    
	public function tes_excel(Request $request)
	{
	    /* initial format excel */
	    ob_end_clean(); 
		ob_start(); 
		
		$file_xls = 'tes_export.xls';
		return Excel::download(new ReportExport(), $file_xls);
	}    
	
	public static function getMaster(){
	   $data = DB::table('ms_product')    
                ->select('id','nama_brg','harga_jual')
                ->orderBy('nama_brg','ASC')
                ->get(); 
                
        return $data;
	}
}
