<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use DB;
use App\Customer;
use App\MSArea;

class CustomerController extends Controller
{
    public function index()
    {
        $area = MSArea::all();
		return view('customer.index', compact('area')); 
    }

    public function listData()
    {
     
	    $customer = Customer::with('getArea')
	                            ->orderBy('cus_name','desc')
							    ->get();
   
        $data = [];
        
        foreach($customer as $list){
       
            $row = array();
            $row[] = $list->cus_name;
            $row[] = $list->cus_address;
            $row[] = $list->cus_kota;
	        $row[] = $list->cus_nohp.' . '.$list->cus_nohp2;
	        $row[] = $list->getArea->kode_area;
	        $row[] = $list->cus_level;
            $row[] = '<div class="btn-btn">
                        <a onclick="editForm('.$list->id_cust.')" class="btn btn-primary btn-xs"><i class="fa fa-pencil"></i></a>
                    </div>';
            $data[] = $row;
        }

        $output = array("data" => $data);
        return response()->json($output);
	 
    }

    public function store(Request $request)
    {

        $customer = new Customer;
        $nama= strtolower($request['nama']);
	  
	    $customer->cus_name     = ucwords($nama);
        $customer->cus_address  = $request['alamat'];
        $customer->cus_kota     = $request['kota'];
	    $customer->cus_nohp	    = $request['nohp'];
	    $customer->cus_nohp2    = $request['nohp2'];
	    $customer->cus_level    = $request['level'];
	    $customer->cus_area     = $request['area'];
	    $customer->user_id	    = Auth::user()->id;
	  
        $customer->save();
      
        echo json_encode(array('msg'=>'success'));
        }

    public function edit($id)
    {
        $customer = Customer::find($id);
        echo json_encode($customer);
    }
    
    public function show($id){
        $customer = Customer::find($id);
        echo json_encode($customer);        
    }
    
    public function update(Request $request, $id)
    {
        $customer = Customer::find($id);
        $nama= strtolower($request['nama']);
      
	    $customer->cus_name     = ucwords($nama);
        $customer->cus_address  = $request['alamat'];
        $customer->cus_kota     = $request['kota'];
	    $customer->cus_nohp	    = $request['nohp'];
	    $customer->cus_nohp2    = $request['nohp2'];
	    $customer->cus_level    = $request['level'];
	    $customer->cus_area     = $request['area'];
	    $customer->user_id	    = Auth::user()->id;
	  
        $customer->update();
      
        echo json_encode(array('msg'=>'success'));
    }
   
}
