<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use Redirect;
use Datatables;
use DB;
use App\Category;

class CategoryController extends Controller
{
   public function index()
   {
		
		return view('category.index');
   }
	
	public function getdata()
	{
		$category = DB::table('ms_category');
			
		return Datatables::of($category)->make(true);

	}

   public function listData()
   {
   
     $category = Category::orderBy('category_name', 'desc')
                                ->where('company_id', Auth::user()->company_id)
                                ->get();
     
     $no = 0;
     $data = [];
     
     foreach($category as $list){

        $row = [];
        if($list->is_active==1){
            $sts='<div class="label label-success">Active</div>';    
        }else{
            $sts='<div class="label label-danger">Non Active</div>';    
        }
       
        $row[] = $list->category_name;
        $row[] = $sts;
        $row[] = '<div class="btn-group">
               <a onclick="editForm('.$list->id.')" class="btn btn-primary btn-sm"><i class="fa fa-pencil"></i></a>
			   </div>';
        $data[] = $row;
     }

     $output = array("data" => $data);
     return response()->json($output);
   }

   public function store(Request $request)
   {
		$category = new Category;

		$category->category_name = ucwords(strtolower($request['nama']));
		$category->company_id    = Auth::user()->company_id;
		$category->is_active     = 1;
		$category->save();
	  
	  echo json_encode(array('msg'=>'success'));
   }
	public function show(){
	}

   public function edit($id)
   {
     $category = Category::find($id);
     echo json_encode($category);
   }

   public function update(Request $request, $id)
   {
      $category = Category::find($id);
	  
      $category->category_name 	= ucwords(strtolower($request['nama']));
      $category->update();
	  
	   echo json_encode(array('msg'=>'success'));
   }

}
