<?php
 
namespace App\Exports;
 
use App\Product;
use DB;

use App\Http\Controllers\ReportController;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class SaleExport implements FromCollection, WithHeadings
{
    
    protected  $tgl1, $tgl2, $cash, $credit;

    function __construct($tgl1, $tgl2, $cash, $credit) {
        
        $this->tgl1 = $tgl1;
        $this->tgl2 = $tgl2;
        $this->cash = $cash;
        $this->credit = $credit;

    }
    
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        
        $data = ReportController::export_to_Excell($this->tgl1, $this->tgl2, $this->cash, $this->credit);
        return $data;
        
    }
    
	/* header di excel */
    public function headings(): array
    {
        return ["NO.INV","NAMA CUSTOMER","TANGGAL","NAMA BARANG","TYPE","HARGA","QTY","ISI","JUMLAH"];
    }    
    
}


